import * as React from 'react';

import { LSSettingItems } from '../../../types';
import { AdminUserReducerState, CASTOM_RESPONSE_STATUSES } from '../../reducers/adminUserReducer';
import { Link } from '../../ui/Link';
import LS from '../../utils/localStorage/localStorage';
import { RESPONSE_STATUSES, SimpleError } from '../SimpleError';
import { ChangeEnv, LOGIN_URL } from '../UserMenu/component';
import { getFavIcons } from './getFavIcons';
import * as style from './index.css';
import { WrapContent } from './WrapContent';

const favIconTesting = require(`./../../../images/favicon_carsharing-testing.png`);

interface IErrorUser {
    data: AdminUserReducerState;
}

const ErrorUser = React.memo((props: IErrorUser) => {
    const errorStatus = props.data.error
        && props.data.error.response
        && props.data.error.response.status;

    return <WrapContent>
        {
            errorStatus === RESPONSE_STATUSES.CODE_401
                ? <Error401 error={props.data.error}/>
                : errorStatus === CASTOM_RESPONSE_STATUSES['403']
                    ? <ErrorRoles/>
                    : errorStatus === RESPONSE_STATUSES.CODE_418
                        ? <ErrorTeapot error={props.data.error}/>
                        : <ErrorElse error={props.data.error}/>
        }
    </WrapContent>;
});

export default ErrorUser;

const ErrorElse = React.memo((props: { error: any }) => {
    return <div className={style.error_401}>
        <h1>Что-то пошло не так :(</h1>
        <SimpleError error={props.error} data={{ label: 'Доступы' }}/>
    </div>;
});

const ErrorTeapot = React.memo((props: { error: any }) => {
    const ls = new LS();
    const allowUrl = `https://prestable.carsharing.yandex-team.ru/#/`;

    return <div className={style.error_418}>
        <div>
            По текущему адресу админки
            <div><img src={`${location.origin}${location.pathname}${getFavIcons().favIcon}`}/><i>{location.origin}</i>
            </div>
            <span className={style.warning}>запрещено</span> ходить в выбранное
            окружение <strong>{ls.get(LSSettingItems.env)}</strong>
            <div>разрешённые окружения:
                <ChangeEnv className={style.env_list}/>
            </div>
        </div>
        <div>
            Доступ к произольному<sup>*</sup> бекенду разрешён по адресу:
            <div><img src={`${location.origin}${location.pathname}${favIconTesting}`}/>
                <Link href={allowUrl}>{allowUrl}</Link>
            </div>
            <div className={style.allow_api}>
                <div><sup>*</sup><span>.(search|carsharing|gencfg-c|yp-c|taxi|taxi-test).yandex.net</span></div>
            </div>
        </div>
    </div>;
});

const Error401 = React.memo((props: { error: any }) => {
    return <div className={style.error_401}>
        <h1>Пользователь не авторизован</h1>
        <SimpleError error={props.error} data={{ label: 'Доступы' }}/>
        <div><a href={LOGIN_URL}>Войти</a></div>
    </div>;
});

const ErrorRoles = React.memo(() => {
    return <div>
        <h1>Нет активных ролей</h1>
    </div>;
});
