import * as React from 'react';
import { RouteChildrenProps } from 'react-router';

import { AdminUserReducerState } from '../../../reducers/adminUserReducer';
import { Link } from '../../../ui/Link';
import { IStore } from '../../App/store';
import { Copy } from '../../Copy';
import { ErrorsWidget } from '../../ErrorLogger/ErrorsWidget';
import { Favourites } from '../../Favourites';
import { FavouritesWidget } from '../../Favourites/FavouritesWidget';
import { SimpleError } from '../../SimpleError';
import { Top10Widget } from '../../Top10Widget';
import { VisitedLog } from '../db';
import { VISITED_TYPES } from '../types';
import * as style from './index.css';

interface IRootContent extends AdminUserReducerState, RouteChildrenProps, IStore {
}

export default class RootContent extends React.Component<IRootContent> {
    state: any = {
        sessions: [],
        cars: [],
        clients: [],
    };

    visitedLog = new VisitedLog();

    componentDidMount(): void {
        this.getLog();
    }

    getLog() {
        this.visitedLog.getTopVisitedCard('session/').then(sessions => {
            this.setState({ sessions });
        });

        this.visitedLog.getTopVisitedCard('cars/').then(cars => {
            this.setState({ cars });
        });

        this.visitedLog.getTopVisitedCard('clients/').then(clients => {
            this.setState({ clients });
        });

        this.getFavourites();
    }

    getFavourites() {
        const favourites = new Favourites().getFormattedData();
        this.setState({ favourites });
    }

    render() {
        const redirectUri = this.props.location
            && this.props.location.search
            && new URLSearchParams(this.props.location.search).get('redirect');
        const fullPath = this.props.location.pathname + this.props.location.search;

        return <div className={style.dashboard}>
            <h2>Привет, <Copy>{this.props.yandex_login}</Copy>!</h2>
            {
                !this.props?.rawSettings?.length
                    ? <SimpleError error={new Error('Нет данных в GVars')}/>
                    : null
            }
            {
                !Object.keys(this.props?.Lang?.localizations || {}).length
                    ? <SimpleError error={new Error('Нет переводов')}/>
                    : null
            }
            <h3>Инструкция по работе с админкой на <Link href={'https://wiki.yandex-team.ru/eva/drive/toall/crmInterface/'}
                                                         target={'_blank'}>
                wiki
            </Link>
            </h3>
            <div className={style.widgets}>
                {this.state.favourites?.length
                    ? <FavouritesWidget path={fullPath}
                                        label={'Избранное'}
                                        update={this.getFavourites.bind(this)}/>
                    : null}
                {this.state.sessions.length
                    ? <Top10Widget withEnv
                                   data={this.state.sessions}
                                   label={'TOP-10 сессий:'}
                                   type={VISITED_TYPES.session}/>
                    : null}
                {this.state.cars.length
                    ? <Top10Widget withEnv data={this.state.cars} label={'TOP-10 авто:'} type={VISITED_TYPES.cars}/>
                    : null}
                {this.state.clients.length
                    ? <Top10Widget withEnv
                                   data={this.state.clients}
                                   label={'TOP-10 пользователей:'}
                                   type={VISITED_TYPES.clients}/>
                    : null}
                <ErrorsWidget/>
            </div>
            {redirectUri && <div className={style.redirect}>
                Ну а такой странички, возможно, и нет: <strong>{redirectUri}</strong>
            </div>}
        </div>;
    }
}
