import * as React from 'react';

import { Dict } from '../../../types';
import { hasWebphonePanel } from '../../utils/hasWebphonePanel';
import * as style from './index.css';
import { wrapContentId } from './types';

export const WrapContent = React.memo((props: { blockRules?: Dict<boolean>; children }) => {
    const webphoneStyles = hasWebphonePanel(location.href, props.blockRules)
        ? style.webphone_is_open
        : '';

    return <div className={`${style.wrap_content} ${webphoneStyles}`}
                id={wrapContentId}>
        {props.children}
    </div>;
});
