import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { createSelectorCreator, defaultMemoize } from 'reselect';

import { AdminUserReducerState } from '../../reducers/adminUserReducer';
import { isObjectEqual } from '../../utils/isObjectEqual';
import { IStore } from '../App/store';
import { Content } from './component';

const createDeepEqualSelector = createSelectorCreator(defaultMemoize, isObjectEqual);

const getAdminUserSelector = (store) => store.AdminUser;
const getLangSelector = (store) => store.Lang;

const getAdminUser = createDeepEqualSelector([getAdminUserSelector], (adminUser) => adminUser);
const getLang = createDeepEqualSelector([getLangSelector], (lang) => lang);

export const mapStateToProps = (store: IStore): IStore => {
    return {
        AdminUser: getAdminUser(store),
        Lang: getLang(store),
    };
};

export interface IAdminUser {
    AdminUser: AdminUserReducerState;
}

export default withRouter<any, any>(connect<IStore, {}, {}>(mapStateToProps)(Content));
