import '@yandex-int/error-counter/dist/interfaceWithoutRum';
import '@yandex-int/error-counter/dist/implementation';
import '@yandex-int/error-counter/dist/filters';
import '@yandex-int/error-counter/dist/sendWithoutRum';
import '@yandex-int/error-counter/dist/logError';
import '@yandex-int/error-counter/dist/logAjaxError';

import moment from 'moment';

export enum ErrorSource {
    BACKEND_RESPONSE = 'backend-response',
    ERROR_BOUNDARY = 'error-boundary',
    POSSIBLE_CHUNK_ERROR = 'possible-chunk-error',
    SIP_ERROR = 'sip_error',
    SIP_ERROR_REGISTRATION = 'sip-error-registration'
}

type TFrontendEnv = Ya.Rum.LogEnvironment | undefined;

export const getFrontendEnv = (): TFrontendEnv => {
    const host = location.host.split('.')[0];

    switch (host) {
    case 'carsharing':
        return 'production';
    case 'localhost':
        return 'development';
    case 'testing':
        return 'testing';
    default:
        return 'prestable';
    }
};

const generateErrorReqid = (userId) => {
    return `${moment().format('DD-MM-YYYYTHH:mm:ss')}-${userId}`;
};

export const initErrorCounter = (userId: string) => {
    window.Ya.Rum.initErrors({
        slots: [],
        reqid: `${generateErrorReqid(userId)}`,
        project: 'DriveAdmin',

        /* optional */
        env: getFrontendEnv(),
        version: `${process.env.VERSION}`,
        referrer: true,
        preventError: false,
        uncaughtException: true,
        debug: true,
        limits: {
            client: 1000,
        },
        silent: {
            external: 3,
        },
    });
};

export const logError = (error: Error, source: ErrorSource, info?: object) => {
    if (window.Ya?.Rum?.logError) {
        window.Ya.Rum.logError(
            {
                additional: info,
                source,
                page: location.href,
            },
            error,
        );
    }
};
