import React, { ReactNode } from 'react';
import { CopyToClipboard } from 'react-copy-to-clipboard';
import ReactTooltip from 'react-tooltip';

import { ONE_SECOND } from '../../constants';
import { IFormatHandlers } from '../../utils/formatter';
import style from './index.css';

const formattedText = (props: any) => {
    return props.formatter ? props.formatter(props.text || props.children) : props.text || props.children;
};

interface IProps {
    customTimeout?: number;
    internalTooltipId?: string;
    children: ReactNode;
    formatter?: IFormatHandlers;
    className?: string;
    text?: string;
    onCopy?: (ref) => void;
    externalTooltipId?: string;
    tooltipConfig?: {
        overridePosition?: (position: {left: number; top: number}) => {left: number; top: number};
        place?: string;
    };
}

export class Copy extends React.Component<IProps, any> {
    tooltip = React.createRef<HTMLSpanElement>()
    timeout: any;

    componentWillUnmount(): void {
        clearTimeout(this.timeout);
        // @ts-ignore
        this.tooltip?.current && ReactTooltip.hide(this.tooltip.current);
    }

    render() {
        return <>
            <CopyToClipboard text={formattedText(this.props)}
                             onCopy={() => {
                                 if (this.tooltip?.current) {
                                     // @ts-ignore
                                     ReactTooltip.show(this.tooltip.current);
                                     this.timeout = setTimeout(() => {
                                         // @ts-ignore
                                         ReactTooltip.hide(this.tooltip.current ?? undefined);
                                     }, this.props.customTimeout ?? ONE_SECOND);
                                 }
                             }}
                             title={'Скопировать в буфер'}
                             style={{ cursor: 'copy' }}>
                <span ref={this.tooltip}
                      className={`${style['text-for-copy']} ${this.props.className || ''}`}
                      data-for={this.props.externalTooltipId ?? this.props.internalTooltipId ?? undefined}
                      data-tip={this.props.externalTooltipId
                          ? `<span>Скопировано<span>`
                          : this.props.internalTooltipId ? true : 'tooltip'}
                      data-event={this.props.externalTooltipId ? 'no-event' : undefined}
                      data-type={this.props.externalTooltipId ? 'dark' : undefined}
                      data-place={this.props?.tooltipConfig?.place ?? 'top'}>
                    {this.props.children}
                </span>
            </CopyToClipboard>
            {!this.props.externalTooltipId
                && <ReactTooltip overridePosition={this.props?.tooltipConfig?.overridePosition}
                                 event={'no-event'}
                                 id={this.props.internalTooltipId ?? undefined}>
                Cкопировано
                </ReactTooltip>}
        </>;
    }
}
