import * as React from 'react';
import { YMInitializer } from 'react-yandex-metrika';

import { LSSettingItems } from '../../../types';
import { CustomSettings } from '../../utils/customSettings';
import LS from '../../utils/localStorage/localStorage';
import { Request2 } from '../../utils/request';
import { sendPerfMetrics } from '../../utils/sendPerfMetrics';
import EntryPoint from '../EntryPoint';
import { ErrorView } from '../GlobalErrorCatchHandler';
import { syncEnv2 } from '../UserMenu/component';
import MY_ROLES_LIST from './classes/MyRoleList';
import { CORE_REQUEST_ENUM, CORE_REQUESTS as requestConfigs } from './request';

const m_id = 55339222;

export class Core extends React.Component<any, any> {
    ls = new LS();
    customSettings = new CustomSettings();

    componentDidMount(): void {
        this.ls.init();
        this.customSettings.init();
        syncEnv2(this.ls);
        this.props.getRoles(this.ls);
        this.storeEvents();
        sendPerfMetrics();
    }

    onStorage(event) {
        if (event.key === this.ls.getName()) {
            if (!LS.compareFields(event.oldValue, event.newValue, LSSettingItems.env)) {
                location.reload();
            }
        }
    }

    storeEvents() {
        window.addEventListener('storage', this.onStorage.bind(this));
    }

    componentWillUnmount(): void {
        window.removeEventListener('storage', this.onStorage.bind(this));
    }

    render() {
        return <>
            <EntryPoint/>
            <YMInitializer accounts={[m_id]}
                           version="2"
                           options={{ params: { location, ls: this.ls.getAllData() } }}/>
        </>;
    }
}

interface IAuth {
    roles: typeof MY_ROLES_LIST[];
    rolesIsLoading: boolean;
    error: any;
    catch: boolean;
}

export class _Auth extends React.Component<any, IAuth> {

    request = new Request2({
        requestConfigs,
    });

    state = {
        roles: [],
        rolesIsLoading: false,
        error: {},
        catch: false,
    };

    componentDidMount(): void {
        this.setState({
            rolesIsLoading: true,
        }, () => {
            this.request.exec(CORE_REQUEST_ENUM.MY_ROLES_LIST)
                .then(response => {
                    this.setState({
                        rolesIsLoading: false,
                        roles: response.report,
                        catch: false,
                    });
                })
                .catch((error: Error) => {
                    this.setState({
                        rolesIsLoading: false,
                        error,
                        catch: true,
                    });
                });
        });
    }

    render() {
        return <div>{
            !this.state.rolesIsLoading && !this.state.catch
                ? this.props.children
                : this.state.catch ? <ErrorView error={this.state.error}/> : null
        }</div>;
    }
}
