import { initPermissions, initRoles, initRules, roleIsLoading } from '../../reducers/adminUserReducer';
import { initLocalization } from '../../reducers/localizationReducer';
import LS from '../../utils/localStorage/localStorage';
import { Request2 } from '../../utils/request';
import { CORE_REQUEST_ENUM, CORE_REQUESTS as requestConfigs } from './request';

export function mapDispatchToProps(dispatch: any) {
    return {
        getRoles: (ls: LS) => {
            const fallbackEndPoints = {
                [CORE_REQUEST_ENUM.MY_ROLES_LIST]: CORE_REQUEST_ENUM.MY_ROLES_LIST_FALLBACK,
                [CORE_REQUEST_ENUM.MY_RULES_LIST]: CORE_REQUEST_ENUM.MY_RULES_LIST_FALLBACK,
                [CORE_REQUEST_ENUM.GET_USER_PERMISSIONS]: CORE_REQUEST_ENUM.GET_USER_PERMISSIONS_FALLBACK,
            };

            let retryCount = 0;
            let isFallback = false;
            const request = new Request2({
                requestConfigs,
            });
            const actions = () => {
                if (retryCount === 1) { // Отвалились на любой из ручек, переходим на fallback- ручки
                    isFallback = true;
                }

                if (retryCount > 1) { // Если отвалились снова - не пытаемся. F5 в помошь!
                    return;
                }

                ++retryCount;

                if (ls?.envIsDM()) {
                    isFallback = true;
                }

                dispatch(roleIsLoading(true, null));
                request.exec(!isFallback
                    ? CORE_REQUEST_ENUM.MY_ROLES_LIST
                    : fallbackEndPoints[CORE_REQUEST_ENUM.MY_ROLES_LIST])
                    .then(response => {
                        request.exec(!isFallback
                            ? CORE_REQUEST_ENUM.MY_RULES_LIST
                            : fallbackEndPoints[CORE_REQUEST_ENUM.MY_RULES_LIST])
                            .then(response => {
                                dispatch(initRules(response, null));
                                request.exec(!isFallback
                                    ? CORE_REQUEST_ENUM.GET_USER_PERMISSIONS
                                    : fallbackEndPoints[CORE_REQUEST_ENUM.GET_USER_PERMISSIONS])
                                    .then((permissions) => {
                                        dispatch(initPermissions(permissions, null));
                                        dispatch(roleIsLoading(false, null));
                                    })
                                    .catch(error => {
                                        actions();
                                        dispatch(initPermissions({}, error));
                                        dispatch(roleIsLoading(false, null));
                                    });
                            })
                            .catch((error) => {
                                actions();
                                dispatch(initRules([], error));
                                dispatch(roleIsLoading(false, null));
                            });
                        dispatch(initRoles(response.report, null));
                    })
                    .catch(error => {
                        dispatch(initRoles([], error));
                        dispatch(initRules([], error));
                        dispatch(initLocalization([], error));
                        dispatch(roleIsLoading(false, error));
                        actions();
                    });
            };

            actions();
        },
    };
}
