import { getActuality, GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { API_PREFIXES, IComponentRequest } from '../../utils/request';

export enum CORE_REQUEST_ENUM {
    /* LOCALIZATIONS = 'LOCALIZATIONS',*/

    MY_ROLES_LIST = 'MY_ROLES_LIST',
    MY_RULES_LIST = 'MY_RULES_LIST',
    GET_USER_PERMISSIONS = 'GET_USER_PERMISSIONS',

    MY_ROLES_LIST_FALLBACK = 'MY_ROLES_LIST_FALLBACK',
    MY_RULES_LIST_FALLBACK = 'MY_RULES_LIST_FALLBACK',
    GET_USER_PERMISSIONS_FALLBACK = 'GET_USER_PERMISSIONS_FALLBACK'
}

export const CORE_REQUESTS: IComponentRequest = {
    [CORE_REQUEST_ENUM.MY_ROLES_LIST]: {
        api: 'my/roles/list',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
    },
    [CORE_REQUEST_ENUM.MY_RULES_LIST]: {
        api: 'settings/info',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            prefix: GVARS_INTERFACE_ADMIN_PREFIX,
            actuality: getActuality(),
        },
    },
    [CORE_REQUEST_ENUM.GET_USER_PERMISSIONS]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'user/permissions',
    },

    //_FALLBACK
    [CORE_REQUEST_ENUM.MY_ROLES_LIST_FALLBACK]: {
        api: 'my/roles/list',
    },
    [CORE_REQUEST_ENUM.MY_RULES_LIST_FALLBACK]: {
        api: 'settings/info',
        cgiObj: {
            prefix: GVARS_INTERFACE_ADMIN_PREFIX,
            actuality: getActuality(),
        },
    },
    [CORE_REQUEST_ENUM.GET_USER_PERMISSIONS_FALLBACK]: {
        api: 'user/permissions',
    },

    /* [CORE_REQUEST_ENUM.LOCALIZATIONS]: {
         apiPrefix: API_PREFIXES.SUPPORT_STAFF,
         api: 'localization/info/',
     },*/
};
