import * as React from 'react';

import { Button, CancelButton } from '../../ui/Button';
import Checkbox from '../../ui/Checkbox';
import { Confirm, Window } from '../../ui/FullModal';
import coreStyle from '../../ui/index.css';
import { Link } from '../../ui/Link';
import Select from '../../ui/Select';
import { isObjectEqual } from '../../utils/isObjectEqual';
import { Request2 } from '../../utils/request';
import { DeferModal } from '../ChatsCommon/DeferChatModal/component';
import { FormConstructor } from '../FormConstructor';
import { REQUESTS, TAG_REQUESTS as requestConfigs } from '../TagModal/request';
import { SCHEMA } from './schema';
import style from './style.css';
import { ICreateChatWindowProps } from './types';

export class CreateChatWindow extends React.Component<ICreateChatWindowProps, any> {
    meta = {};
    state: any = {
        text1: '',
        text2: '',
        additional_comment: '',

        initialData: {
            object_id: this.props.object_id,
            comment: this.props.link ?? '',
        },
        meta: {},
        _permanentComment: '',
        isValid: false,
        error: null,
        showLink: false,
        topic_link: '',
        showDeferringCheckbox: false,
        deferChat: false,
        openDeferringWindow: false,
        selectedChatItem: null,
    };
    request = new Request2({ requestConfigs });

    shouldComponentUpdate(nextProps: Readonly<ICreateChatWindowProps>, nextState: Readonly<any>): boolean {
        return !isObjectEqual(nextProps.rawSettings, this.props.rawSettings) || !isObjectEqual(nextState, this.state);
    }

    componentWillUnmount() {
        this.request.abort();
    }

    onSelectTag(tag) {
        const {
            initial_node,
            title,
            text1,
            text2,
            additional_comment = '',
        } = this.props.rawSettings.find(el => el.tag === tag?.toString()) ?? {};

        if (initial_node) {
            this.setState({
                text1,
                text2,
                additional_comment,
                initialData: {
                    ...this.state.initialData,
                    initial_node,
                    tag,
                    title,
                    additional_comment,
                    ...{ comment: this.state._permanentComment }, //#DRIVEFRONT-583
                },
            }, () => {
                this.checkForDeferring();
            });
        } else {
            this.setState({ initialData: { object_id: this.props.object_id } }, () => {
                this.checkForDeferring();
            });
        }
    }

    onChange(meta, isValid) {
        this.setState({
            meta, isValid, _permanentComment: meta.comment,
        });
    }

    createChat() {
        this.props.object_id && this.setState({
            isLoading: true,
            error: null,
        }, () => {
            const final_comment = this.getChatComment();
            let body;

            if (final_comment) {
                body = Object.assign({}, this.state.meta, { comment: final_comment });
            } else {
                body = Object.assign({}, this.state.meta);
                delete body['comment'];
            }

            delete body['additional_comment'];

            this.request.exec(REQUESTS.ATTACH_USER_TAG, {
                body,
                queryParams: { report_tag_info: true },
            })
                .then((response) => {
                    this.setState({
                        isLoading: false,
                        showLink: !this.state.deferChat,
                        topic_link: response?.added_tags_data?.[0]?.topic_link,
                        openDeferringWindow: this.state.deferChat,
                        selectedChatItem: this.state.deferChat ? response?.added_tags_data?.[0] : null,
                    });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    getLink() {
        return <div>
            {this.state.topic_link && this.props.object_id
                && <h3>
                    <Link href={`#/${this.props.type}?user_id=${this.props.object_id}&chat_id=${this.state.topic_link}`}
                          target={'_blank'}>ссылка на чатик</Link>
                </h3>}
            <div className={style.text2}>{this.state.text2}</div>
        </div>;
    }

    getChatComment(): string {
        const { comment, additional_comment } = this.state.meta;
        let final_comment = '';

        final_comment += comment ? comment : '';
        final_comment += comment && additional_comment ? '\n' : '';
        final_comment += additional_comment ? additional_comment : '';

        return final_comment;
    }

    checkForDeferring() {
        const setting = this.props.rawSettings.find(el => {
            return el.tag === this.state.initialData?.tag;
        }) ?? {};

        const to_morning = setting.to_morning;

        this.setState({ showDeferringCheckbox: Boolean(to_morning) });
    }

    onCheckboxChange(deferChat) {
        this.setState({ deferChat });
    }

    onDeferred() {
        this.setState({ showLink: true, openDeferringWindow: false });
    }

    render() {
        return <Window title={`Создать чат (${this.props.type})`}
                       onClose={this.props.onClose.bind(this)}
                       error={this.state.error}>
            {this.state.showLink
            && <Confirm error={null}
                        onClose={this.props.onClose.bind(this)}
                        title={'Вот твоя ссылка, саппорт'}
                        acceptTitle={'Ok'}
                        ignoreCancelBtn
                        question={this.getLink()}
                        accept={this.props.onClose.bind(this)}/>}

            {this.state.openDeferringWindow
                ? <DeferModal selectedChatItem={this.state.selectedChatItem}
                              onClose={this.onDeferred.bind(this)}
                              deferUntilMorning={true}
                              onDeferred={this.onDeferred.bind(this)}/>
                : null
            }

            <Select placeholder={'Причина'}
                    options={this.props?.rawSettings
                        ?.filter(_el => _el.enabled && (!_el.type || _el.type === this.props.type))
                        ?.map((_el: any) => {
                            return {
                                text: _el.name || _el.tag,
                                value: _el.tag,
                                description: _el.title,
                            };
                        })}
                    onSelect={this.onSelectTag.bind(this)}/>
            <FormConstructor schema={SCHEMA}
                             initialData={this.state.initialData}
                             onChange={this.onChange.bind(this)}/>

            {this.state.showDeferringCheckbox
                ? <span className={style.checkbox_item}>
                    <span>Отложить чат до утра: </span>
                    <Checkbox checked={this.state.deferChat}
                              onChange={this.onCheckboxChange.bind(this)}
                              placeholder={'Отложить до утра'}/>
                </span>
                : null
            }

            <div className={style.text1}>{this.state.text1}</div>
            <div className={coreStyle.button_container}>
                <CancelButton onClick={this.props.onClose.bind(this)}/>
                <Button onClick={this.createChat.bind(this)}
                        disabled={!this.state.isValid}
                        isLoading={this.state.isLoading}>Создать</Button>
            </div>
        </Window>;
    }
}
