import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_DOC_TEMPLATES = 'GET_DOC_TEMPLATES',
    GET_DOC_PREVIEW = 'GET_DOC_PREVIEW',
    PUT_DOC_IN_QUEUE = 'PUT_DOC_IN_QUEUE'
}

export const DOC_TEMPLATE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_DOC_TEMPLATES]: {
        api: 'documents/list',
        cgiObj: {
            is_active: null,
            for_queue: null,
        },
    },
    [REQUESTS.GET_DOC_PREVIEW]: {
        api: 'documents/preview',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.PUT_DOC_IN_QUEUE]: {
        api: 'documents/schedule',
        method: REQUEST_METHOD.POST,
    },
};
