import React from 'react';

import { CancelButton, SaveButton } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Input } from '../../../../ui/Input';
import { Request2 } from '../../../../utils/request';
import { DOC_TEMPLATE_REQUESTS as requestConfigs, REQUESTS } from '../request';
import { IDoc } from '../types';

interface IChangeDocQueueModalProps {
    onClose: () => void;
    item: IDoc | null;
}

interface IChangeDocQueueModalState {
    newQueueValue: string;
    isChanging: boolean;
    changingError: Error | null;
}

export default class ChangeDocQueueModal extends React.Component<IChangeDocQueueModalProps, IChangeDocQueueModalState> {
    state: IChangeDocQueueModalState = {
        newQueueValue: '',
        isChanging: false,
        changingError: null,
    };
    request = new Request2({ requestConfigs });

    constructor(props: IChangeDocQueueModalProps) {
        super(props);
        const { item } = this.props;
        const inputs = item?.inputs ?? {};
        const { queue } = inputs;

        this.state = { newQueueValue: queue ?? '', isChanging: false, changingError: null };
    }

    onNewQueueValueChange(newQueueValue: string) {
        this.setState({ newQueueValue });
    }

    changeQueue() {
        const { item, onClose } = this.props;
        const { newQueueValue } = this.state;
        const id = item?.id ?? '';

        this.setState({ isChanging: true, changingError: null }, () => {
            this.request.exec(REQUESTS.CHANGE_DOC_QUEUE, { body: { id: id, queue: newQueueValue } })
                .then(() => {
                    this.setState({ isChanging: false });
                    onClose();
                })
                .catch(changingError => {
                    this.setState({ changingError, isChanging: false });
                });
        });
    }

    render() {
        const { onClose, item } = this.props;
        const { newQueueValue, isChanging, changingError } = this.state;
        const inputs = item?.inputs ?? {};
        const { document_name } = inputs;

        return <Window title={`Смена очереди для документа ${document_name}`}
                       onClose={onClose.bind(this)}
                       error={changingError}>
            <Input value={newQueueValue}
                   onChange={this.onNewQueueValueChange.bind(this)}
                   placeholder={'Новая очередь'}
                   disabled={isChanging}/>

            <div className={coreStyle.button_container}>
                <CancelButton onClick={onClose.bind(this)}/>
                <SaveButton onClick={this.changeQueue.bind(this)}
                            isLoading={isChanging}/>
            </div>
        </Window>;
    }
}
