import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_DOCS_QUEUE = 'GET_DOCS_QUEUE',
    GET_DOCS_HISTORY = 'GET_DOCS_HISTORY',
    CANCEL_DOC_BUILDING = 'CANCEL_DOC_BUILDING',
    CHANGE_DOC_QUEUE = 'CHANGE_DOC_QUEUE',
}

export const DOC_TEMPLATE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_DOCS_QUEUE]: {
        api: 'documents/queue',
        cgiObj: {
            all: null,
        },
    },
    [REQUESTS.GET_DOCS_HISTORY]: {
        api: 'document_queue/history',
        cgiObj: {
            start_ts: null,
            document_name: null,
            user: null,
        },
    },
    [REQUESTS.CANCEL_DOC_BUILDING]: {
        method: REQUEST_METHOD.POST,
        api: 'document_queue/cancel',
    },
    [REQUESTS.CHANGE_DOC_QUEUE]: {
        method: REQUEST_METHOD.POST,
        api: 'document_queue/set_queue',
    },
};
