import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_DOC_TEMPLATES = 'GET_DOC_TEMPLATES',
    GET_DOC_TEMPLATE_HISTORY = 'GET_DOC_TEMPLATE_HISTORY',
    UPSERT_DOC_TEMPLATES = 'UPSERT_DOC_TEMPLATES',
    REMOVE_DOC_TEMPLATES = 'REMOVE_DOC_TEMPLATES',
}

export const DOC_TEMPLATE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_DOC_TEMPLATES]: {
        api: 'documents/list',
        cgiObj: {
            is_active: null,
            for_queue: null,
        },
    },
    [REQUESTS.GET_DOC_TEMPLATE_HISTORY]: {
        api: 'documents/history',
        cgiObj: {
            start_ts: null,
            document_name: null,
        },
    },
    [REQUESTS.UPSERT_DOC_TEMPLATES]: {
        method: REQUEST_METHOD.POST,
        api: 'documents/upsert',
    },
    [REQUESTS.REMOVE_DOC_TEMPLATES]: {
        method: REQUEST_METHOD.POST,
        api: 'documents/remove',
    },
};
