export enum contentTypeEnum {
    raw = 'raw',
    package = 'package'
}

export enum DOC_TYPES_DISPLAY_NAME {
    raw = 'Документ',
    package = 'Пакет'
}

export enum DOC_FORMAT {
    pdf = 'pdf',
    csv = 'csv',
    json = 'json',
}

export const CURRENT_VISUAL_CONTENT_TYPES = [contentTypeEnum.raw];
export const ALL_GROUPING_TAG_TAB = 'all_grouping_tag';
export const GROUPING_TAG_KEY = 'grouping_tag';

export interface ITemplate {
    content_type: contentTypeEnum;
    comment: string;
    document_meta: {
        templates: string[]; content: string; additional_parameters: string[];
        groupping_tags: string;
        queue: string;
        use_user_watermark: boolean; document_format: string;
    }
    & { documents: ITemplate[] };
    document_name: string;
    active: boolean;
    use_user_watermark: boolean;
}

//template with vars for cars, user etc.
export interface IDocTemplate {
    name: string;
    inputs: string[];
    outputs: string[];
}

export interface ISchema {
    document_name: string;
    comment: string;
    groupping_tags: string;
    queue: string;
    active: boolean;
    use_user_watermark: boolean;
    document_format: string;
    templates: string[];
    raw: {
        content: string;
        additionalParams: string[];
    };
    package: {
        documents: string[];
        currentDocuments: string[];
    };
}
