import React from 'react';

import { DUTY_STATE } from '../../constants';
import { Button } from '../../ui/Button';
import { Window } from '../../ui/FullModal';
import * as coreStyle from '../../ui/index.css';
import { Request2 } from '../../utils/request';
import { setDocumentTitle } from '../../utils/utils';
import { IDutyProps, IDutyState } from './DutyCommonModal';
import { continueDuty } from './handler';
import * as style from './index.css';
import { DUTY_REQUESTS } from './request';

export class AbsenceModal extends React.Component<IDutyProps, IDutyState> {
    state = {
        isLoading: false,
        error: null,
    };
    title = 'Смена 🔒';
    request = new Request2({ requestConfigs: DUTY_REQUESTS });

    componentDidMount(): void {
        setDocumentTitle(this.title);
    }

    componentWillUnmount(): void {
        setDocumentTitle();
    }

    onClose() {

    }

    render() {
        return <Window onClose={this.onClose} error={this.state.error} title={this.title}>
            <div className={style.absence_confirm}>
                <h2>Мы тут понаблюдали 🕵️...</h2>
                <h2>Кажется, вы очень долго ничего не делаете 🤷...</h2>
                <h3>Может, пора начать работать? 👩‍💻👨‍💻</h3>
                <h4>статус: {this.props.tags[0].tag}</h4>
                <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
                    <Button onClick={continueDuty.bind(this, DUTY_STATE.COMMON)}
                            isLoading={this.state?.isLoading}>Ой, ну всё...давайте</Button>
                </div>
            </div>
        </Window>;
    }
}
