import React from 'react';
import { connect } from 'react-redux';

import { DUTY_STATE } from '../../constants';
import { Button } from '../../ui/Button';
import Checkbox from '../../ui/Checkbox';
import { Window } from '../../ui/FullModal';
import * as coreStyle from '../../ui/index.css';
import { Request2 } from '../../utils/request';
import { setDocumentTitle } from '../../utils/utils';
import { IStore } from '../App/store';
import MY_ROLES_LIST from '../Core/classes/MyRoleList';
import { IDutyProps, IDutyState } from './DutyCommonModal';
import { continueDuty } from './handler';
import * as style from './index.css';
import { DUTY_REQUESTS, REQUESTS } from './request';

interface IProps extends IDutyProps, IMapStateToProps {

}

interface IState extends IDutyState {
    checks: boolean[];
    loading: boolean[];
}

class EnterModal extends React.Component<IProps, IState> {
    state = {
        isLoading: false,
        error: null,
        checks: this.props?.rolesRaw?.map((item: typeof MY_ROLES_LIST) => item?.user_role?.active === '1') || [],
        loading: new Array(this.props?.rolesRaw?.length).fill(false),
    };
    title = 'Смена 🏁';
    request = new Request2({ requestConfigs: DUTY_REQUESTS });

    componentDidMount(): void {
        setDocumentTitle(this.title);
    }

    componentWillUnmount(): void {
        setDocumentTitle();
    }

    disable(index, state) {
        this.setState((prev) => {
            const loading = prev.loading;
            loading[index] = state;

            return {
                loading,
            };
        });
    }

    updateRoles() {
        this.setState({ isLoading: true }, () => {
            this.request.exec(REQUESTS.GET_USER_ROLES)
                .then(response => {
                    this.setState(
                        {
                            error: null,
                            isLoading: false,
                            checks: this.getChecks(response.report),
                        });
                })
                .catch(error => {
                    this.setState({ error, isLoading: false });
                });
        });
    }

    getChecks(roles) {
        const roleActives = {};
        roles?.forEach(role => roleActives[role.role_id] = role.active);

        return this.props?.rolesRaw?.map((item: typeof MY_ROLES_LIST) => {
            return roleActives[item?.user_role?.role_id] === '1';
        }) || [];
    }

    toggle(index) {
        this.setState((prev) => {
            const checks = prev.checks;
            checks[index] = !checks[index];

            return {
                checks,
                error: null,
            };
        });
    }

    switch(index, role: typeof MY_ROLES_LIST) {
        this.disable(index, true);
        const action = this.state.checks[index] ? 'deactivate' : 'activate';
        this.request.exec(REQUESTS.ACTIVATE_USER_ROLE, {
            queryParams: {
                action: action,
                user_id: role.user_role.user_id,
                role_id: role.role_description?.role_id,
            },
        })
            .then(() => {
                this.updateRoles();
                this.disable(index, false);
                this.toggle(index);
            })
            .catch((error) => {
                this.disable(index, false);
                this.setState({
                    error,
                });
            });
    }

    render() {
        return <Window onClose={() => {}} error={this.state.error} title={this.title}>
            <div className={style.absence_confirm}>
                <h2>Привет!</h2>
                <h3>Добро пожаловать на смену поддержки Драйва.</h3>
                <h3>Успехов сегодня и береги наших пользователей!</h3>
                <h4>Включаем только одну роль</h4>
                <div className={style.roles}>
                    {
                        this.props?.rolesRaw?.map((item: typeof MY_ROLES_LIST, index) => {
                            return <div key={index} className={style.role_item}>
                                <Checkbox checked={this.state.checks[index]}
                                          disabled={this.state.loading[index]}
                                          onChange={this.switch.bind(this, index, item)}/>
                                {
                                    item.role_description?.role_description
                                    || item.role_description?.role_id
                                }
                            </div>;
                        })
                    }
                </div>
                <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
                    <Button onClick={continueDuty.bind(this, DUTY_STATE.COMMON)}
                            isLoading={this.state.isLoading}>Погнали 🏎️</Button>
                </div>
            </div>
        </Window>;
    }
}

interface IMapStateToProps {
    rolesRaw: MY_ROLES_LIST[] | undefined;
}

export const mapStateToProps = (store: IStore): IMapStateToProps => {
    return {
        rolesRaw: store.AdminUser?.rolesRaw.filter((role: typeof MY_ROLES_LIST) => {
            return role?.role_description?.role_groupping_tags?.includes(DUTY_STATE.COMMON);
        }),
    };
};

export default connect(mapStateToProps, {})(EnterModal);
