import React from 'react';

import { DUTY_STATE } from '../../constants';
import { Button, ButtonTypes, CancelButton } from '../../ui/Button';
import { Window } from '../../ui/FullModal';
import * as coreStyle from '../../ui/index.css';
import { Request2 } from '../../utils/request';
import { setDocumentTitle } from '../../utils/utils';
import { IDutyProps, IDutyState } from './DutyCommonModal';
import { continueDuty } from './handler';
import * as style from './index.css';
import { DUTY_REQUESTS } from './request';

interface IProps extends IDutyProps {
    onClose: Function;
}

export class ToBreakConfirm extends React.Component<IProps, IDutyState> {
    state = {
        isLoading: false,
        error: null,
    };
    title = 'Смена 🏁';
    request = new Request2({ requestConfigs: DUTY_REQUESTS });

    componentDidMount(): void {
        setDocumentTitle(this.title);
    }

    componentWillUnmount(): void {
        setDocumentTitle();
    }

    render() {
        return <Window onClose={this.props.onClose.bind(this)} error={this.state.error} title={this.title}>
            <div className={style.absence_confirm}>
                <h2>Хорошо поработали?</h2>
                <h3>Отдыхай, восстанавливайся и снова за работу 🙃</h3>
                <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
                    <CancelButton onClick={this.props.onClose.bind(this)}/>
                    <Button onClick={continueDuty.bind(this, DUTY_STATE.BREAK)}
                            isLoading={this.state.isLoading}>Ухожу, но скоро вернусь!</Button>
                    <Button onClick={continueDuty.bind(this, DUTY_STATE.ENDED)}
                            colorType={ButtonTypes.negative}
                            isLoading={this.state.isLoading}>Закончить смену</Button>
                </div>
            </div>
        </Window>;
    }
}
