import { DUTY_STATE } from '../../constants';
import { REQUESTS } from './request';

export const continueDuty = function (this, tag: DUTY_STATE) {
    this.setState({
        isLoading: true,
        error: null,
    }, () => {

    });
    this.request.exec(REQUESTS.TAG_EVOLVE, {
        queryParams: {
            tag_id: this.props.tags[0].tag_id,
        },
        body: {
            tag,
            priority: this.props.tags[0].priority,
            object_id: this.props.tags[0].object_id,
        },
    })
        .then(response => {
            this.setState({
                error: null,
            }, () => {
                location.reload();
            });
        })
        .catch((error) => {
            this.setState({
                error,
                isLoading: false,
            });
        });
};
