import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    TAG_EVOLVE = 'TAG_EVOLVE',
    ACTIVATE_USER_ROLE = 'ACTIVATE_USER_ROLE',
    GET_USER_ROLES = 'GET_USER_ROLES',
}

export const DUTY_REQUESTS: IComponentRequest = {
    [REQUESTS.TAG_EVOLVE]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/evolve',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.ACTIVATE_USER_ROLE]: {
        method: REQUEST_METHOD.POST,
        api: 'user/roles/${action}',
        cgiObj: {
            user_id: null,
            role_id: null,
            action: null,
        },
    },
    [REQUESTS.GET_USER_ROLES] : {
        api: 'user/roles/list',
        cgiObj: {
            user_id: null,
        },
    },
};
