import * as React from 'react';
import { HashRouter, Route } from 'react-router-dom';

import useConsoleOpen from '../../hooks/useConsoleOpen';
import { chunksErrorHandling } from '../../utils/chunksErrorHandling';
import { getCookie } from '../../utils/cookie';
import { CSSettingsItems, CustomSettings } from '../../utils/customSettings';
import { isDevOrigin } from '../../utils/frontendEnvironment';
import { hasWebphonePanel } from '../../utils/hasWebphonePanel';
import LS from '../../utils/localStorage/localStorage';
import { ytLogs } from '../../utils/sendLogs';
import { EVENT_TYPES } from '../../utils/sendLogs/eventTypes/eventTypes';
import Content from '../Content';
import * as style from '../Core/index.css';
import Header from '../Header/';
import { CenteredSpin } from '../Spin';
import SystemAlertsContainer from '../SystemAlertsContainer';
import { IEntryPointMapStateToProps } from './index';

const Webphone = React.lazy(() => chunksErrorHandling(() => import('../Webphone')));

const EntryPoint = React.memo((props: IEntryPointMapStateToProps) => {
    const ls = new LS();
    const ref = React.useRef<any>(null);
    const log = ytLogs.getInstance();
    const customSettings = new CustomSettings();
    let consoleOpen;
    if (!ls.envIsTesting() && !isDevOrigin()) {
        consoleOpen = useConsoleOpen();
    }

    if (consoleOpen) {
        log.send({
            data: {
                event_type: EVENT_TYPES.CUSTOM_LOG,
                meta: {
                    location: location.href,
                    yl: getCookie('yandex_login'),
                    type: 'console.log',
                },
            },
        });
    }

    const isNightMode = customSettings.get(CSSettingsItems.nightMode);
    if (isNightMode) {
        ref?.current?.parentNode?.classList.add(style.nightMode);
    }

    return <HashRouter>
        <Route path={'/:routeState?'}
               render={() => {
                   const hasWebphone = hasWebphonePanel(location.href, props?.BlockRules);

                   return <div ref={ref}
                               className={`${style.component} ${hasWebphone ? style.hasWebphone : ''}`}>
                       <Header/>
                       <Content/>
                       <SystemAlertsContainer/>
                       {hasWebphone && <React.Suspense fallback={<CenteredSpin size={'s'}/>}>
                           <Webphone/>
                       </React.Suspense>}
                   </div>;
               }}/>
    </HashRouter>;
});

export default EntryPoint;
