import { connect } from 'react-redux';

import { IStore } from '../App/store';
import EntryPoint from './component';

export interface IEntryPointMapStateToProps {
    BlockRules: Record<string, boolean>;
    userId: string;
}

export const mapStateToProps = (store: IStore): IEntryPointMapStateToProps => {
    return {
        BlockRules: store?.AdminUser?.blockRules ?? {},
        userId: store?.AdminUser?.userId ?? '',
    };
};

export default connect(mapStateToProps)(EntryPoint);
