import * as React from 'react';

import { ENVIRONMENT } from '../../../types';
import { EMPTY_DATA } from '../../constants';
import { Cross } from '../../ui/Cross';
import FormatDate from '../../ui/FormatDate';
import { Link } from '../../ui/Link';
import { LabelStatus, TLabel } from '../../ui/Table';
import { getStatusType } from './getStatusType';
import * as style from './index.css';

const MAX_ERRORS_COUNT = 99;
const MAX_END_POINT_LENGTH = 50;

export class ErrorLoggerTableItem extends React.Component<any> {
    render() {
        const { index, item, showInfo, deleteItem } = this.props;
        let envStatus = LabelStatus.DEFAULT;

        const endpoint = item?.endpoint?.length > MAX_END_POINT_LENGTH
            ? item?.endpoint?.substr(0, MAX_END_POINT_LENGTH) + '...'
            : item?.endpoint;

        switch (item?.env) {
        case ENVIRONMENT.ADMIN:
        case ENVIRONMENT.PRESTABLE:
            envStatus = LabelStatus.POSITIVE;
            break;
        case ENVIRONMENT.CUSTOM:
            envStatus = LabelStatus.NEGATIVE;
            break;
        default:
            envStatus = LabelStatus.DEFAULT;
            break;
        }

        return <div style={this.props.style} className={style.row}>
            <span className={style.cell}>
                {index + 1}
            </span>

            <span className={style.cell}>
                <FormatDate value={item?.date} withSecond/>
            </span>

            <span className={style.cell}>{item?.env &&
            <TLabel status={envStatus}
                    text={item?.env.toString()}/> || EMPTY_DATA}
            </span>

            <span className={style.cell}>
                {item?.version}
            </span>

            <span className={style.cell}>
                {item?.status &&
                <TLabel status={getStatusType(item)}
                        text={item.status.toString()}/> || EMPTY_DATA}
                {item?.repeated && item.repeated > 1
                    ? <div className={style.repeated}>{item.repeated > MAX_ERRORS_COUNT ? '>99' : item.repeated}</div>
                    : null
                }
            </span>

            <span className={`${style.cell} ${style.error_log}`}>
                <span className={style.error_log}>
                    {
                        decodeURIComponent(endpoint)
                    }
                </span>
                <span className={style.error_log}>
                    {item?.data?.error_details?.ui_message
                        ? <>
                            <span className={style.error_text}>
                                {item?.data?.error_details?.ui_message};
                            </span>
                        </> : null}
                </span>
                <span className={style.error_log}>
                    {item?.data?.error
                        ? <>
                            <strong>error: </strong>
                            <span className={style.error_text}>
                                {typeof item.data.error === 'object'
                                    ? JSON.stringify(item.data.error)
                                    : typeof item.data.error === 'string' && item.data.error || ''}
                            </span>
                        </> : null}
                </span>
                <span>
                    {item?.data?.debug
                        ? <>
                            <strong>debug: </strong>
                            <span className={style.error_text}>
                                {item.data.debug}
                            </span>
                        </> : null}
                </span>
            </span>

            <span className={style.cell}>
                {!item?.repeated || item.repeated === 1
                    ? <Link onClick={showInfo}>info</Link>
                    : null
                }
            </span>

            <span className={style.cell}>
                <Link onClick={deleteItem.bind(this, index)}
                      title={'delete'}
                      className={item?.repeated > 1 ? style.hidden : null}>
                    <Cross className={style.remove_icon}/>
                </Link>
            </span>

        </div>;
    }
}
