import * as React from 'react';

import { EMPTY_DATA } from '../../constants';
import { JsonModal } from '../../ui/FullModal/JsonModal';
import { isValidJSONString } from '../../utils/isValidJSONString';

export const ErrorModal = React.memo((props: { onClose: (boolean) => void; item }) => {
    const error = props.item?.data?.error &&
        (typeof props.item.data.error === 'object'
            ? JSON.stringify(props.item?.data?.error)
            : props.item?.data?.error)
        || EMPTY_DATA;

    if (isValidJSONString(props.item.requestData)) {
        props.item.requestData = JSON.parse(props.item.requestData);
    }

    if (isValidJSONString(props.item.message)) {
        props.item.message = JSON.parse(props.item.message);
    }

    return <JsonModal onClose={props.onClose.bind(null, false)}
                      title={'Просмотр ошибки'}
                      obj={props.item}>
        <div>oшибка:
            <strong>{props.item?.status || EMPTY_DATA}</strong>
        </div>
        <div>error:
            <strong>{props.item?.data?.error_details?.ui_message || EMPTY_DATA}</strong>
        </div>
        <div>ui:
            <strong>{error}</strong>
        </div>
    </JsonModal>;
});
