import React from 'react';

import { Dict } from '../../../types';
import { Link } from '../../ui/Link';
import { buttonLocationDetails, buttonNameDetails } from '../../utils/sendLogs/eventTypes/buttonDetails';
import { IFastTagItem, tagTypes } from '../InterfaceAdminConfig/FastTags/schema';
import styles from './index.css';

interface IFastTagsViewProps {
    fastTags?: IFastTagItem[] | null;
    BlockRules: Dict<any>;
    place?: buttonLocationDetails.CAR_CARD | buttonLocationDetails.CLIENT_CARD | buttonLocationDetails.CLIENT_INFO;
    addTag?: () => void;
}

export const FastTagsView = React.memo((props: IFastTagsViewProps) => {
    const { fastTags, place, addTag, BlockRules } = props;

    const ytLog = {
        button_name: buttonNameDetails.FAST_SERVICE_TAGS,
        location: place,
    };
    const tags = fastTags?.filter(_el => {
        if(place === buttonLocationDetails.CLIENT_INFO) {
            return _el.enabled && _el.tagType === tagTypes.CLIENT
                && (_el.for_rules?.only_for_rules ? _el.for_rules.array_rules?.some(el => BlockRules[el]) : true);
        }

        return _el.enabled && _el.place?.some?.(el => el === place)
            && (_el.for_rules?.only_for_rules ? _el.for_rules.array_rules?.some(el => BlockRules[el]) : true); //DRIVEFRONT-996
    }) || [];

    return tags.length ? <div className={styles.fast_tags}>
        {

            tags?.map((_el, key: number) => {
                const { alias } = _el;

                return (
                    <Link className={styles.fast_tag_item}
                          key={key}
                          onClick={addTag?.bind(null, _el)}
                          ytLog={ytLog}>
                        {alias}
                    </Link>
                );
            })
        }
    </div> : null;
});
