import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { getRawSetting2 } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { fast_tags2 } from '../InterfaceAdminConfig/adminConfigKeys';
import { FastTagsView } from './component';

const fastTags = `${GVARS_INTERFACE_ADMIN_PREFIX}.${fast_tags2}`;

export const mapStateToProps = (store: IStore) => {
    return {
        fastTags: getRawSetting2(store, fastTags),
        BlockRules: store.AdminUser?.blockRules,
    };
};

export default connect(mapStateToProps)(FastTagsView);
