import * as React from 'react';

import { LSSettingItems } from '../../../types';
import { CancelButton, DeleteButton, SaveButton } from '../../ui/Button';
import { Confirm, Window } from '../../ui/FullModal';
import * as coreStyle from '../../ui/index.css';
import LS from '../../utils/localStorage/localStorage';
import { FormConstructor } from '../FormConstructor';
import { Favourites, IFavItem } from './index';
import { FAVOURITES_FORM, IFavFormValues } from './schema';

interface IModalWindowProps {
    onClose: () => void;
    isAddAction: boolean;
    path: string;
}

interface IModalWindowState {
    formTitle: string;
    formLocation: string;
    isConfirmOpen: boolean;
    isFormValid: boolean;
    error: Error | null;
}

export class FavouritesModal extends React.Component<IModalWindowProps, IModalWindowState> {
    state: IModalWindowState = {
        formTitle: '',
        formLocation: '',
        isConfirmOpen: false,
        isFormValid: true,
        error: null,
    };
    fv = new Favourites();
    ls = new LS();

    onFormChange(data: IFavFormValues, isFormValid: boolean) {
        this.setState({
            formTitle: data?.title,
            formLocation: data?.location,
            isFormValid,
        });
    }

    setFav() {
        const favItem: IFavItem = {
            title: this.state.formTitle,
            env: this.ls.get(LSSettingItems.env),
        };

        const location = this.formatLocation();

        this.fv.set(location, favItem);
        this.props.onClose();
    }

    formatLocation(): string {
        if (this.state.formLocation.includes('http')) {
            return this.state.formLocation.slice(this.state.formLocation.indexOf('#') + 1);
        }

        return this.state.formLocation;

    }

    removeFav() {
        this.fv.remove(this.props.path);
        this.props.onClose();

        this.setState({ isConfirmOpen: false });
    }

    openConfirm(isConfirmOpen: boolean) {
        this.setState({ isConfirmOpen });
    }

    render() {
        const { onClose, path, isAddAction } = this.props;

        const item: IFavItem = this.fv.getData()[path];
        const title: string = isAddAction ? path : item?.title;

        return <>
            <Window title={'Редактировать избранное'}
                    onClose={onClose.bind(this, false)}>
                <FormConstructor schema={FAVOURITES_FORM}
                                 onChange={this.onFormChange.bind(this)}
                                 initialData={{ title, location: path }}/>

                <div className={coreStyle.button_container}>
                    <CancelButton onClick={onClose.bind(this)}/>

                    {!isAddAction
                        ? <DeleteButton onClick={this.openConfirm.bind(this, true)}/>
                        : null
                    }

                    <SaveButton onClick={this.setFav.bind(this)} disabled={!this.state.isFormValid}/>
                </div>
            </Window>

            {this.state.isConfirmOpen
                ? <Confirm question={`Удалить ${title || 'элемент'}?`}
                           onClose={this.openConfirm.bind(this, false)}
                           accept={this.removeFav.bind(this)}
                           error={this.state.error}/>
                : null
            }
        </>;
    }
}
