import * as React from 'react';

import { ENVIRONMENT } from '../../../types';
import { Confirm } from '../../ui/FullModal';
import { Link } from '../../ui/Link';
import * as style from '../Content/index.css';
import { EnvWidgetBadge } from '../Top10Widget/EnvWidgetBadge';
import * as top10Style from '../Top10Widget/index.css';
import { FavouritesModal } from './FavouritesModal';
import { FavFormattedData, FavFormattedDataItem, Favourites } from './index';

interface IFavouritesWidgetProps {
    path: string;
    label: string;
    update: () => void;
}

interface IFavouritesWidgetState {
    isFavEditOpen: boolean;
    isConfirmOpen: boolean;
    item: FavFormattedDataItem | null;
}

export class FavouritesWidget extends React.Component<IFavouritesWidgetProps, IFavouritesWidgetState> {
    state: IFavouritesWidgetState = {
        isConfirmOpen: false,
        isFavEditOpen: false,
        item: null,
    };
    fv = new Favourites();

    openFavEdit(isFavEditOpen: boolean, item: FavFormattedDataItem | null) {
        this.setState({ isFavEditOpen, item });
    }

    openConfirm(isConfirmOpen: boolean) {
        this.setState({ isConfirmOpen });
    }

    onRemoveAll() {
        this.fv.reset();
        this.openConfirm(false);
        this.props.update();
    }

    render() {
        const { item, isFavEditOpen, isConfirmOpen } = this.state;
        const data: FavFormattedData = this.fv.getFormattedData();

        return <div className={`${top10Style.top10} ${style.favourites}`}>
            <div className={style.header}>
                <h4>{this.props.label}</h4>

                <div className={style.fav_head_controls}>
                    <Link onClick={this.openFavEdit.bind(this, true, null)}
                          className={style.add_item}>Добавить</Link>

                    <Link onClick={this.openConfirm.bind(this, true)}>Очистить</Link>
                </div>
            </div>
            <ul className={style.favourites_table}>
                {
                    data.map((item, index) => {
                        const href = `#${item[0]}`;

                        return <li key={index}>
                            <EnvWidgetBadge env={item[1]?.env as ENVIRONMENT}/>
                            <Link href={href} className={style.title}>{item[1]?.title}</Link>
                            <Link onClick={this.openFavEdit.bind(this, true, item)}
                                  className={style.edit}>ред.</Link>
                        </li>;
                    })
                }
            </ul>

            {
                isFavEditOpen
                    ? <FavouritesModal onClose={this.openFavEdit.bind(this, false, null)}
                                       isAddAction={false}
                                       path={item?.[0] || ''}/>
                    : null
            }

            {
                isConfirmOpen
                    ? <Confirm question={'Очистить избранное?'}
                               accept={this.onRemoveAll.bind(this)}
                               error={null}
                               onClose={this.openConfirm.bind(this, false)}/>
                    : null
            }
        </div>;
    }
}
