import { isValidJSONString } from '../../utils/isValidJSONString';

export interface IFavItem {
    title: string;
    env: string;
}

interface IFavData {
    [path: string]: IFavItem;
}

export type FavFormattedDataItem = [string, IFavItem];
export type FavFormattedData = [string, IFavItem][];

export class Favourites {
    private _name = '_da_ls_fav';
    private default = {};
    private _ls = window.localStorage;

    constructor() {
        this.init();
    }

    init() {
        if (!this._ls.getItem(this._name)) {
            this.reset();
        }
    }

    getData(): IFavData {
        const data = this._ls.getItem(this._name);
        let formattedData;

        if (data && isValidJSONString(data)) {
            formattedData = JSON.parse(data);
        }

        return formattedData || this.default;
    }

    getFormattedData(): FavFormattedData {
        return Object.entries(this.getData());
    }

    set(key: string, val: IFavItem) {
        const obj = this.getData();
        obj[key] = val;

        this._update(obj);
    }

    match(link: string): boolean {
        return this.getData()?.hasOwnProperty(link);
    }

    remove(link: string) {
        const obj = this.getData();
        delete obj[link];

        this._update(obj);
    }

    private _update(obj: IFavData) {
        this._ls?.setItem(this._name, JSON.stringify(obj));
    }

    reset() {
        this._ls?.setItem(this._name, JSON.stringify(this.default));
    }
}
