import { LinesMenuType } from '../ChatsCommon/types';

export interface IFavLineItem {
    display_name: string;
    chats: {
        urgent: number;
    };
    group: string;
    type?: FAV_LINES_TYPES;
}

export enum FAV_LINES_TYPES {
    chats = 'chats',
    dispatcher = 'dispatcher',
}

export const FAVOURITES = 'Favourites';
export const FAV_ACTION = {
    ADD: 'add',
    REMOVE: 'remove',
};

export class FavouritesLines {
    private _name = '_da_ls_fav_lines';
    private default = {};
    private _ls = window.localStorage;

    constructor() {
        this.init();
    }

    init() {
        if (!this._ls.getItem(this._name)) {
            this.reset();
        }
    }

    add(key: string, val: IFavLineItem) {
        const obj = this.getData();
        obj[key] = val;
        this._update(obj);
    }

    remove(id: string) {
        const obj = this.getData();
        delete obj[id];

        this._update(obj);
    }

    getData() {
        const data = this._ls.getItem(this._name);
        let formattedData;
        try {
            formattedData = data && JSON.parse(data);
        } catch (e) {

        }

        return formattedData || this.default;
    }

    getChatsCount(groupName: string, id: string) {
        const itemName = `${groupName}__${id}`;
        const item = this.getData()[itemName] || {};

        return item.chats || null;
    }

    static getTargetChats(line) {
        const { urgent = [] } = line?.chats || {};

        return urgent.length && {
            urgent: urgent.length,
        } || null;
    }

    getConfirmQuestion(group: string, el: string): string {
        return this.match(group, el) ? 'Удалить линию из избранного?' : 'Добавить линию в избранное?';
    }

    check(group, line) {
        const { name } = line || {};
        const count = this.getChatsCount(group, name);
        const targetChats = FavouritesLines.getTargetChats(line);
        if (count && targetChats && count.urgent !== targetChats.urgent) {
            return {
                count,
                targetChats,
                line,
                group,
            };
        }

        return null;
    }

    checkTasksCount(data: LinesMenuType) {
        const lsData = this.getData();
        const result: any = [];

        Object.entries(lsData).map((favLine: any) => {
            const name = this.decodeName(favLine[0]);
            const element = data[name.group]?.items.find(el => el.name === name.el);
            if (favLine[1]?.chats?.urgent !== element?.chats_count) {
                if (favLine[1]?.chats?.urgent < element?.chats_count) {
                    result.push(element);
                }

                this.updateChatsCount(name.group, name.el, { urgent: element?.chats_count });
            }
        });

        return result.length ? result : null;
    }

    decodeName(name: string): { group: string; el: string } {
        const identifier = '__';
        const decodedName = name.split(identifier);

        return { group: decodedName[0], el: decodedName[1] };
    }

    updateChatsCount(groupName: string, id: string, chats) {
        const itemName = `${groupName}__${id}`;
        const item = this.getData()?.[itemName] || {};
        item.chats = chats;

        this.add(itemName, item);
    }

    match(groupName: string, id: string): boolean {
        return this.getData()?.hasOwnProperty(`${groupName}__${id}`);
    }

    private _update(obj: IFavLineItem) {
        this._ls?.setItem(this._name, JSON.stringify(obj));
    }

    reset() {
        this._ls?.setItem(this._name, JSON.stringify(this.default));
    }
}
