import React from 'react';

import { Dict } from '../../../../../types';
import { Request2 } from '../../../../utils/request';
import { IChatMessageItemProps } from '../../../Chats/ChatWindow/ChatWindowContent/ChatMessageItem/component';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import { FINE_REQUEST as requestConfigs, FINE_REQUEST_ENUM } from '../../request';
import { ShortFineInfoBlock } from '../ShortFineInfo';

interface IFineInfoMessageState {
    isLoading: boolean;
    data: Dict<any> | null;
    error: Error | null;
}

export class FineInfoMessageBlock extends React.Component<IChatMessageItemProps, IFineInfoMessageState> {
    state: IFineInfoMessageState = {
        isLoading: false,
        data: null,
        error: null,
    };
    request = new Request2({ requestConfigs });

    componentDidMount(): void {
        this.getFineInfo();
    }

    getFineInfo() {
        this.setState({
            isLoading: true,
        }, () => {
            this.props?.item?.text && this.request
                .exec(FINE_REQUEST_ENUM.GET_DATA, {
                    queryParams: {
                        fine_id: this.props.item.text || '',
                    },
                })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        error: null,
                        data: response?.[0] || {},
                    });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    render() {
        return <div>
            {
                this.state.isLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : this.state.data
                            ? <ShortFineInfoBlock fineInfo={this.state.data}/>
                            : null
            }
        </div>;
    }
}
