import moment from 'moment';
import * as React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { rubs } from '../../../../utils/rubs';
import CarNumber from '../../../CarNumber';
import { DISPUTE_DAYS_COUNT, RESOLUTION_PREFIX } from '../../../Clients/FinesView/constants';
import * as style from '../index.css';
import { getFullKoap } from './getFullKoap';

export const ShortFineInfoBlock = React.memo((props: { fineInfo: Dict<any> ; className?: string }) => {
    const { fineInfo, className } = props;
    const dispute_deadline = +moment(fineInfo.ruling_date).add(DISPUTE_DAYS_COUNT, 'days');

    return <div className={`${className} ${style.container}`}>
        <div className={style.fine_item}>
            <span className={style.item_title}>Сумма:</span>
            <span className={style.item_info}>{fineInfo.sum_to_pay ? rubs(fineInfo.sum_to_pay) : EMPTY_DATA}</span>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Автомобиль:</span>
            <span className={style.item_info}>
                {fineInfo?.car?.model?.name && fineInfo?.car?.id
                    ? <Link href={'#/cars/' + fineInfo.car.id + '/info'} target="_blank">
                        {fineInfo.car.model.name}
                    </Link>
                    : EMPTY_DATA}
            </span>
            <span className={style.item_info}>
                {fineInfo?.order?.id
                    ? <>
                        <span> / </span>
                        <Link href={'#/session/' + fineInfo.order.id} target="_blank">
                            Сессия
                        </Link>
                    </>
                    : EMPTY_DATA}
            </span>
        </div>

        <div className={style.fine_item}>
            {fineInfo?.car?.number
                ? <CarNumber carInfo={fineInfo.car}/>
                : EMPTY_DATA}
            <div className={style.ctc}>
                СТС: {fineInfo.car?.registration_id || EMPTY_DATA}
            </div>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Статья КоАП:</span>
            <span className={style.item_info}>{getFullKoap(fineInfo)}</span>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Постановление №:</span>
            <span className={style.item_info}>
                {fineInfo.ruling_number
                    ? <Link href={`${RESOLUTION_PREFIX}${fineInfo.ruling_number}`}
                            target={'__blank'}>
                        {fineInfo.ruling_number}
                    </Link>
                    : EMPTY_DATA
                }
            </span>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Постановление:</span>
            <span className={style.item_info}>
                <span className={style.dates}> {<FormatDate value={fineInfo.ruling_date}
                                                            onlyDate={true}/> ?? EMPTY_DATA} </span>
            </span>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Оспаривание до:</span>
            <span className={style.item_info}>
                <span className={style.dates}> {<FormatDate value={dispute_deadline}
                                                            onlyDate={true}/> ?? EMPTY_DATA} </span>
            </span>
        </div>

        <div className={style.fine_item}>
            <span className={style.item_title}>Дата:</span>
            <span className={style.dates}>
                <FormatDate withSecond={true} value={fineInfo.violation_time * ONE_SECOND}/>
            </span>
        </div>
    </div>;
});
