import produce from 'immer';
import React from 'react';

import FormatDate from '../../ui/FormatDate';
import { Link } from '../../ui/Link';
import * as tblStyle from '../../ui/Table/index.css';
import { Request2 } from '../../utils/request';
import CarNumber from '../CarNumber';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import * as style from './index.css';
import { FINE_REQUEST, FINE_REQUEST_ENUM } from './request';

export class Fines extends React.Component {
    request = new Request2({ requestConfigs: FINE_REQUEST });
    state = {
        isLoading: false,
        data: {} as any,
        error: null,
    };

    getData(page: number) {
        this.setState(produce(this.state, draft => {
            draft.isLoading = true;
            draft.error = null;
        }), () => {
            this.request.exec(FINE_REQUEST_ENUM.GET_DATA, { queryParams: { page } })
                .then(response => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.error = null;
                        draft.data = response || {};
                    }));
                })
                .catch(error => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.error = error;
                    }));
                });
        });

    }

    componentDidMount(): void {
        this.getData(1);
    }

    render() {
        return <div className={style.component}>
            <h2>Штрафы</h2>
            {
                this.state.isLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : <table className={tblStyle.table}>
                            <tbody>
                                {
                                    this.state.data
                            && this.state.data.results
                            && Array.isArray(this.state.data.results)
                            && this.state.data.results.map((item: any, index) => {
                                return <tr key={index}>
                                    <td>{++index}</td>
                                    <td>{item.car && item.car.number && <CarNumber carInfo={item.car}/>}</td>
                                    <td><Link target={'_blank'}
                                              href={`${location.origin}/#/cars/${item.car.id}/info`}>
                                        {item.car && item.car.model && item.car.model.name}
                                    </Link>
                                    </td>
                                    <td><FormatDate value={item.charged_at}/></td>
                                    <td>{item.ruling_number}</td>
                                    <td>{item.sum_to_pay}₽</td>
                                    <td>{item.article_koap}</td>
                                </tr>;
                            })
                                }
                            </tbody>
                        </table>
            }
        </div>;
    }
}
