import React from 'react';

import { requestQueueWithAllSettled } from '../../../hooks/useRequestQueueHandler';
import { Button } from '../../../ui/Button';
import { INIT_VALUE_ERROR } from '../../../ui/FileInput';
import { MDS_REQUESTS, REQUESTS } from '../../../ui/FileInput/request';
import { Request2 } from '../../../utils/request';
import style from './index.css';

interface IButtonSTProps {
    onClick: (data?: any, event?: any) => void;
}

const ButtonUploadST = ({ onClick }: IButtonSTProps) => {
    const requestCallback = (files) => {
        const request = new Request2({ requestConfigs: MDS_REQUESTS });
        const requestQueue = () => {
            return [...files].map(file => {
                const media = new Blob([file], { type: file.type });

                return request.exec(REQUESTS.ADD_ST_RESOURCES, {
                    file: media,
                    queryParams: {
                        file_name: file.name,
                    },
                    headers: {
                        'Content-Type': media.type || 'image',
                    },
                });
            });
        };

        const arrayItems: string[] = [];

        requestQueueWithAllSettled(requestQueue, () => {
            arrayItems.push(INIT_VALUE_ERROR);
        }).then((response) => {
            response.map(el => {
                if (Object.keys(el).length) {
                    arrayItems.push(el?.attachment_id);
                }
            });
            onClick(arrayItems);
        });
    };

    return (
        <Button className={style.multiple_add_button}
                basic
                file
                onClick={requestCallback}>
            Загрузить несколько фото
        </Button>
    );
};

export default ButtonUploadST;
