import * as React from 'react';

import { SimpleError } from '../SimpleError';
import { FormConstructorInputs } from './FormConstructorInputs';
import { IFormConstructorProps } from './types';

export class FormConstructor extends React.Component<IFormConstructorProps, { error: Error | null }> {
    constructor(props) {
        super(props);
        this.state = { error: null };
    }

    static getDerivedStateFromError(error) {
        return { error };
    }

    componentDidUpdate(prevProps: Readonly<IFormConstructorProps>, prevState: Readonly<{ error: Error | null }>): void {
        if (JSON.stringify(this.props.schema) !== JSON.stringify(prevProps.schema)
            || JSON.stringify(this.props.initialData) !== JSON.stringify(prevProps.initialData)
            || this.props.onChange !== prevProps.onChange
            || this.props.className !== prevProps.className) {

            this.setState({ error: null });
        }
    }

    render() {
        const { error } = this.state;

        if (error) {
            return <SimpleError error={error} data={{ label: 'Не удалось собрать форму' }}/>;
        }

        return <FormConstructorInputs {...this.props}/>;
    }
}
