import { Dict } from '../../../types';
import { GLOBAL_SEARCH_OBJECTS } from '../../ui/IDSelect/constants';

export enum controlType {
    string = 'string',
    text = 'text',
    json = 'json',
    array_types = 'array_types',
    bool = 'bool',
    numeric = 'numeric',
    variants = 'variants',
    structure = 'structure',
    variable = 'variable', //{control_field: Dict<ISchemaItem>, variants_fields: Dict<Dict<ISchemaItem>>, default_fields: Dict<ISchemaItem>}
    separator = 'separator',
    string_vector = 'string_vector', //deprecated
    ignore = 'ignore'
}

export enum SchemaItemVisual {
    //string
    DATE_ISO = 'DATE_ISO',
    COLOR = 'color',
    FILE = 'File',
    MEDIA_RESOURCE = 'MEDIA_RESOURCE',
    FILE_ST = 'File_ST',
    ID_SELECT = 'id_select',

    //numeric
    TIMESTAMP = 'timestamp',
    RUBS = 'rubs',
    MONEY = 'money',

    //structure
    TABLE = 'Table'
}

export interface ISchemaItem {
    //common
    display_name?: string;
    order?: number;
    read_only?: boolean;
    tab_name?: string;
    type?: controlType;
    default?: any;
    deprecated?: boolean;
    required?: boolean;
    description?: string;

    //string, numeric, structure
    visual?: SchemaItemVisual;

    //string
    templateList?: string[];
    maxLength?: number;
    //string > ID_SELECT
    object?: GLOBAL_SEARCH_OBJECTS;

    //variants
    variants?: any[]; //string[] | IOptionInfo[]
    multi_select?: boolean;
    array_type?: Dict<ISchemaItem> | ISchemaItem;
    editable?: boolean;
    //variants > reference
    reference?: string;

    //numeric
    min?: number;
    max?: number;
    //numeric > timestamp
    _only_date?: boolean;

    //variable
    control_field?: Dict<ISchemaItem>;
    variants_fields?: Dict<Dict<ISchemaItem>>;
    default_fields?: Dict<ISchemaItem> | Dict<Dict<ISchemaItem>>;

    //structure
    collapsed?: boolean;
    structure?: Dict<ISchemaItem>;
    //textarea
    withoutCross?: boolean;
}

export interface IFormConstructorProps {
    schema: Dict<ISchemaItem>;
    initialData?: Dict<any> | null;
    onChange?: (data: Dict<any>, isValid?: boolean, isFormChanged?: boolean) => void;
    className?: string;
    rawResult?: boolean;
    hideChanges?: boolean; //if this flag is true, block with form changes is hidden
}
