import { Dict } from '../../../../types';

export const isObject = (value: any) => {
    if (value) {
        return typeof value === 'object' && value.constructor === Object;
    }

    return false;
};

export const removeNullValues = (data: Dict<any>) => {
    return Object.entries(data).reduce((result: Dict<any>, entry: [string, any]) => {
        const [key, value] = entry;

        if (value !== null) {
            if (value && typeof value === 'object') {
                if (Array.isArray(value)) {
                    result[key] = value.filter(valueItem => valueItem !== null)
                        .map(valueItem => {
                            if (typeof valueItem === 'object') {
                                return removeNullValues(valueItem);
                            }

                            return valueItem;

                        });
                } else {
                    result[key] = removeNullValues(value);
                }
            } else {
                result[key] = value;
            }
        }

        return result;
    }, {});
};

export const isValueExist = (value: any) => {
    if (value === null || value === undefined) {
        return false;
    }

    if (typeof value === 'object') {

        if (Array.isArray(value)) {
            return value.length !== 0;
        }

        //Check if object is Date
        if (typeof value.getMonth === 'function') {
            return true;
        }

        //Check if object is RegExp
        if (typeof value.test === 'function') {
            return true;
        }

        return Object.keys(value)?.length !== 0;

    }

    if (typeof value === 'number') {
        return !isNaN(value);
    }

    if (typeof value === 'string') {
        return value !== '';
    }

    return !((Array.isArray(value) && value.length === 0)
        || value === '' || value === null || value === undefined);
};
