import * as React from 'react';
import ReactJson from 'react-json-view';

import { Dict } from '../../../types';
import { ViewerJSON } from '../../ui/FullModal/ViewerJSON';
import { isObjectEqual } from '../../utils/isObjectEqual';
import { deepCopy } from '../../utils/utils';
import { FormConstructor } from '../FormConstructor';
import { controlType, ISchemaItem, SchemaItemVisual } from '../FormConstructor/types';
import * as style from './index.css';

const longText = `Очень длинный текст, который не помещается вообще в строку и его следовало бы убрать в description.` +
    `Так что сам буду переносить из display_name в description, если description пустой ` +
    `Так что сам буду переносить из display_name в description, если description пустой`;

const MAIN_SCHEMA: Dict<ISchemaItem> = {
    numeric_field_0: { type: controlType.numeric, display_name: 'numeric_field_0', order: 1, min: -1, max: 1 },
    string_field: { type: controlType.string, display_name: 'Строка', order: 1, tab_name: 'strings tab' },
    string_field2: {
        type: controlType.string,
        display_name: 'Строка2',
        order: 1,
        default: 'a',
        tab_name: 'strings tab',
    },
    text_field: { type: controlType.text, display_name: 'text_field', order: 2, tab_name: 'strings tab' },
    json_field: { type: controlType.json, display_name: 'json_field', order: 3, tab_name: 'strings tab' },
    bool_field2: { type: controlType.bool, display_name: 'bool_field2', order: 4 },
    bool_field: { type: controlType.bool, display_name: 'bool_field', order: 4 },
    numeric_field: { type: controlType.numeric, display_name: 'numeric', order: 5 },
    numeric_field_: { type: controlType.string, display_name: longText, order: 6 },
    array_types_field: {
        type: controlType.array_types,
        display_name: 'Массив array_types_field',
        tab_name: 'structures tab',
        order: 6,
        array_type: {
            type: controlType.string,
            display_name: 'Элемент массива string_array_field',
            order: 1,
        },
        default: ['a', 'b'],
    },
    array_types_structure_field: {
        type: controlType.array_types,
        display_name: 'array_types_field',
        tab_name: 'structures tab',
        order: 7,
        array_type: {
            str: {
                type: controlType.string,
                display_name: 'string_array_field',
                tab_name: 'str',
                order: 1,
            },
            nmb: {
                type: controlType.numeric,
                display_name: 'numeric_array_field',
                tab_name: 'nmb',
                order: 2,
            },
        },
        default: [{ str: '1', nmb: 1 }, { str: '2', nmb: 2 }],
    },
    variants_fields: {
        type: controlType.variants,
        display_name: 'variants_fields',
        variants: ('abcdefghijklmnopqrstuvwxyz').split(''),
        order: 8,
        multi_select: true,
        editable: true,

    },
    structure_field: {
        type: controlType.structure,
        display_name: 'structure_field',
        tab_name: 'structures tab',
        order: 9,
        structure: {
            str: {
                type: controlType.string, display_name: 'string_structure_field', order: 1,
            },
            nmb: {
                type: controlType.numeric, display_name: 'numeric_structure_field', order: 2,
            },
        },
    },
    variable_field: {
        type: controlType.variable,
        display_name: 'variable_field',
        tab_name: 'structures tab',
        control_field: {
            control_variants_fields: {
                type: controlType.variants,
                display_name: 'variable_variants_fields',
                variants: ['simple', 'hard'],
                default: 'simple',
            },
        },
        variants_fields: {
            simple: {
                string_field: { type: controlType.string, display_name: 'simple_string', tab_name: 'string_field_tab' },
                string_field_2: {
                    type: controlType.string,
                    display_name: 'simple_string',
                    tab_name: 'string_field_2_tab',
                },
            },
            hard: {
                timestamp: { type: controlType.numeric, visual: SchemaItemVisual.TIMESTAMP, tab_name: 'timestamp_tab' },
                json: { type: controlType.json, tab_name: 'json_tab' },
                variable_nested_field: {
                    type: controlType.variable,
                    display_name: 'variable_nested_field',
                    tab_name: 'variable tab',
                    control_field: {
                        control_variants_nested_fields: {
                            type: controlType.variants,
                            display_name: 'variable_variants_nested_fields',
                            variants: ['simple_nested', 'hard_nested'],
                            default: 'simple_nested',
                        },
                    },
                    variants_fields: {
                        simple_nested: {
                            string_nested_field: { type: controlType.string, display_name: 'string_nested_field' },
                        },
                        hard_nested: {
                            json_nested: { type: controlType.json },
                        },
                    },
                },
            },
        },
    },
};

export default class FormConstructorView extends React.Component<any, any> {
    constructor(props) {
        super(props);

        this.onFormChange = this.onFormChange.bind(this);
        this.onSchemaChange = this.onSchemaChange.bind(this);
    }

    state = {
        schemaViewType: 'text',
        values: {},
        isFormValid: false,
        schema: deepCopy(MAIN_SCHEMA),
        initSchema: deepCopy(MAIN_SCHEMA),
        isFormChanged: false,
        isFormValuesChanged: false,
    };

    onFormChange(values: Dict<any>, isFormValid: boolean, isFormValuesChanged: boolean) {
        this.setState({ values, isFormValid, isFormValuesChanged });
    }

    onSchemaChange(val) {
        if (!isObjectEqual(val, this.state.initSchema) || this.state.isFormChanged) {
            this.setState({ schema: val, isFormChanged: true });
        }
    }

    render() {
        return <div className={style.form_constructor_view}>
            <div>
                <ViewerJSON onChange={this.onSchemaChange}
                            JSONData={this.state.isFormChanged
                                ? { textarea: this.state.schema }
                                : { textarea: this.state.initSchema }}/>
            </div>
            <div className={style.form_container}>
                <FormConstructor onChange={this.onFormChange} schema={this.state.schema}/>
            </div>
            <div>
                <h3>Форма валидна: {this.state.isFormValid ? 'Да' : 'Нет'}</h3>
                <h3>Форма Изменилась: {this.state.isFormValuesChanged ? 'Да' : 'Нет'}</h3>
                <ReactJson src={this.state.values}/>
            </div>
        </div>;
    }
}
