import React from 'react';

import { useRequestHandler } from '../../hooks/useRequestHandler';
import { Button } from '../../ui/Button';
import { Window } from '../../ui/FullModal';
import { Request2 } from '../../utils/request';
import { FormConstructor } from '../FormConstructor';
import style from './index.css';
import { requestConfigs, REQUESTS } from './request';

export class FuelOrder extends React.Component<any, any> {
    state = {
        modalIsOpen: false,
        isLoading: false,
        error: null,
        schema: {},
        orderData: {},
    };

    request = new Request2({ requestConfigs });

    showModal(modalIsOpen) {
        this.setState({
            modalIsOpen,
        });
    }

    createOrder() {
        this.setState({
            isLoading: true,
        }, () => {
            this.state.orderData
            && Object.keys(this.state.orderData)?.length
            && this.request.exec(REQUESTS.CREAT_ORDER, {
                queryParams: {
                    user_id: this.props?.match?.params?.client_id,
                },
                body: this.state.orderData,
            })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        modalIsOpen: false,
                        error: false,
                    });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    componentWillUnmount() {
        this.request.abort();
    }

    onChange(orderData) {
        this.setState({
            orderData,
        });
    }

    render() {
        return this.props.BlockRules?.UserRefuel && <div>
            <Button onClick={this.showModal.bind(this, true)}>Создать заказ</Button>
            {
                this.state.modalIsOpen
                && <Modal onClose={this.showModal.bind(this, false)}
                          user_id={this.props?.match?.params?.client_id}
                          isLoading={this.state.isLoading}
                          request={this.request}
                          onChange={this.onChange.bind(this)}
                          createOrder={this.createOrder.bind(this)}
                          error={this.state.error}/>
            }
        </div> || null;
    }
}

const Modal = (props) => {
    const options = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_SCHEMA,
            requestOptions: {
                queryParams: {},
            },
        };
    }, []);

    const [isLoading, response, error, makeResponse] = useRequestHandler<any>(props.request, options);

    React.useEffect(() => {
        makeResponse();
    }, []);

    return <Window onClose={props.onClose}
                   title={`${isLoading ? 'Загрузка схемы' : 'Создать заказ'}`}
                   error={props.error || error}>
        <FormConstructor schema={response?.request_data?.structure || {}}
                         className={style.fc}
                         onChange={props.onChange}
                         initialData={{ user_id: props.user_id }}/>
        <div>
            <Button onClick={props.createOrder} isLoading={props.isLoading}>Создать</Button>
        </div>
    </Window>;
};
