import { IComponentRequest } from '../../utils/request';

export const REQUESTS: { [key: string]: string } = {
    GET_DATA: 'GET_DATA',
    GET_CARS: 'GET_CARS',
    GET_TELEMATICS: 'GET_TELEMATICS',
    GET_MAINTENANCE: 'GET_MAINTENANCE',
    GET_CAR_INFO: 'GET_CAR_INFO',
    SEARCH_TAGS: 'SEARCH_TAGS',
    GET_USER_ROLES: 'GET_USER_ROLES',
    GET_USER_TAGS: 'GET_USER_TAGS',
    GET_USER_ACCOUNTS: 'GET_USER_ACCOUNTS',
};

const FUELING_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_DATA]: {
        api: 'geo/tags/history',
        cgiObj: {
            tag_names: 'user_fueling_order,fueling_result_tag',
            since: null,
            until: null,
            numdoc: null,
        },
    },
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            traits: null,
            tags_filter: null,
        },
    },
    [REQUESTS.GET_TELEMATICS]: {
        api: 'car/telematics/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_MAINTENANCE]: {
        api: `maintenance/info`,
        cgiObj: {
            vin: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: `car/info`,
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.SEARCH_TAGS]: {
        api: 'tags/search',
        cgiObj: {
            has_one_of: null,
            limit: null,
        },
    },
    [REQUESTS.GET_USER_ROLES]: {
        api: 'user/roles/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_USER_ACCOUNTS]: {
        api: 'billing/accounts',
        cgiObj: {
            user_id: null,
        },
    },
};

export { FUELING_REQUESTS };
