import { API_PREFIXES, IComponentRequest } from '../../../utils/request';

export const REQUESTS = {
    GET_CARS: 'GET_CARS',
    GET_CAR_INFO: 'GET_CAR_INFO',
    SEARCH: 'SEARCH',
    GET_HAHN_DATA: 'GET_HAHN_DATA',
};

export const REQUEST: IComponentRequest = {
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.SEARCH]: {
        api: 'search',
        cgiObj: {
            has_all_of: null,
            limit: null,
            what: null,
        },
    },
    [REQUESTS.GET_HAHN_DATA]: {
        apiPrefix: API_PREFIXES.YT,
        api: 'v3/read_table',
        cgiObj: {
            path: null,
            ['output_format[$value]']: null,
            ['output_format[$attributes][encode_utf8]']: null,
            dump_error_into_response: null,
        },
    },
};
