import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_MAINTENANCE = 'GET_MAINTENANCE',
    SET_MAINTENANCE = 'SET_MAINTENANCE',
    DELETE_MAINTENANCE = 'DELETE_MAINTENANCE',
}

export const TO_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_MAINTENANCE]: {
        api: 'maintenance/info',
    },
    [REQUESTS.SET_MAINTENANCE]: {
        method: REQUEST_METHOD.POST,
        api: 'maintenance/upsert',
    },
    [REQUESTS.DELETE_MAINTENANCE]: {
        api: 'maintenance/remove',
        cgiObj: {
            vin: null,
        },
    },
};
