import * as React from 'react';

import { EMPTY_DATA } from '../../../../constants';
import { Window } from '../../../../ui/FullModal';
import * as styleTable from '../../../../ui/Table/index.css';
import { FUEL_COMPANIES, IFuelCardCarItem } from '../types';

interface IFuelCardsModalProps {
    fuelCards: IFuelCardCarItem[];
    onClose: () => void;
}

export default class FuelCardsModal extends React.PureComponent<IFuelCardsModalProps> {

    render() {
        const { onClose, fuelCards } = this.props;

        const fuelCompaniesArray = Object.values(FUEL_COMPANIES).reduce((result: string[], fuelCompany) => {
            const { name, pin_key } = fuelCompany;
            result.push(name, pin_key);

            return result;
        }, []);

        return <Window title={'Топливные карты'} onClose={onClose.bind(this)}>
            <table className={styleTable.table}>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>VIN</th>
                        {fuelCompaniesArray.map(fuelCompany => {
                            return <th key={fuelCompany}>{fuelCompany}</th>;
                        })}
                    </tr>
                </thead>
                <tbody>
                    {fuelCards?.map((listItem, index) => {
                        const { vin } = listItem;

                        return <tr key={vin}>
                            <td>{index + 1}</td>
                            <td>{vin}</td>
                            {fuelCompaniesArray.map(fuelCompany => {
                                return <td key={`${fuelCompany}_${fuelCompany}`}>
                                    {listItem[fuelCompany] ?? EMPTY_DATA}
                                </td>;
                            })}
                        </tr>;
                    })}
                </tbody>
            </table>
        </Window>;
    }
}
