import * as React from 'react';

import { LSSettingItems } from '../../../types';
import { Collapse2 } from '../../ui/Collapse2';
import { Link } from '../../ui/Link';
import LS from '../../utils/localStorage/localStorage';
import { SimpleError } from '../SimpleError';
import * as style from './index.css';

interface IState {
    error: Error;
    errorInfo: React.ErrorInfo;
}

export class GlobalErrorCatchHandler extends React.Component<any, IState> {
    state = {
        error: {} as Error,
        errorInfo: {} as React.ErrorInfo,
    };

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void {
        this.setState({
            error, errorInfo,
        });
    }

    render(): React.ReactNode {
        return this.state.errorInfo && this.state.errorInfo.componentStack
            ? <ErrorView error={this.state.error}/>
            : this.props.children;
    }
}

export const ChunksErrorView = (error) => {
    const reloadLocation = () => {
        location.reload(true);
    };

    const errorView = <SimpleError error={error} />;

    return <div className={style.chunksError}>
        <div className={style.title}>
            ⚠️ Кажется у вас старая версия админки или оборвалось соединение с Интернетом.
        </div>
        <div className={style.main}>
            Пожалуйста, перезагрузите страницу. Если ошибка не устранилась, проверьте свое
            подключение.&nbsp;
            <Link onClick={reloadLocation}>
                Перезагрузить сейчас
            </Link>
        </div>
        <div className={style.metaData}>
            <div><b>ver:</b> {process.env.VERSION}</div>
            <div><b>env:</b> {new LS().get(LSSettingItems.env)}</div>
            <div><b>path:</b> {location.href}</div>
        </div>

        {error
            ? <Collapse2 title={'Ошибка'} expandText={'Показать ошибку'} children={errorView} initialExpanded={false}/>
            : null
        }
    </div>;
};

export const ErrorView = (props: any) => {
    const { error = {} } = props;

    return <div className={style.error}>
        <div>status: <span>{error.status || error.message}</span></div>
        <div>message: <span>{error.message || error.error} {error.statusText}</span></div>
        <div>
            {(error.stack + '')
                .split('\n').map((_el: string, index: number) =>
                    <div key={index}><span>{_el}</span></div>)}
        </div>
    </div>;
};
