import React, { useEffect, useState } from 'react';

import { CancelButton, SaveButton } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import IDSelect from '../../../ui/IDSelect/component';
import * as coreStyle from '../../../ui/index.css';
import { Request2 } from '../../../utils/request';
import { CALL_REQUESTS, REQUESTS } from './request';

interface IAttachUserRequestModalProps {
    openBindClientModal: (isOpen: boolean) => void;
    values: {
        tag_id: string;
        call_id: string;
        user_id: string;
    };
}

export const USER_REQUEST_TAG = 'user_support_request';

export const AttachUserRequestModal = (props: IAttachUserRequestModalProps) => {
    const request = new Request2({ requestConfigs: CALL_REQUESTS });
    const [clientId, setClientId] = useState('');
    const [isLoading, setLoading] = useState(false);
    const [error, setError] = useState(null);

    function attachTag() {
        setLoading(true);

        request.exec(REQUESTS.ATTACH_USER_TAG, {
            body: {
                tag: USER_REQUEST_TAG,
                object_id: clientId,
                fields: [
                    {
                        key: 'tag_id',
                        value: props.values.tag_id,
                    },
                    {
                        key: 'call_id',
                        value: props.values.call_id,
                    },
                    {
                        key: 'user_id',
                        value: props.values.user_id,
                    },
                ],
                priority: 0,
            },
        })
            .then(() => {
                setLoading(false);
                props.openBindClientModal(false);
            })
            .catch(error => {
                setLoading(false);
                setError(error);
            });
    }

    useEffect(() => {
        return () => {
            request.abort();
        };
    }, []);

    return <Window onClose={props.openBindClientModal.bind(null, false)}
                   title={`Выбор клиента`}
                   error={error}>
        <IDSelect onSelect={setClientId.bind(null)}/>

        <div className={coreStyle.button_container}>
            <CancelButton onClick={props.openBindClientModal.bind(null, false)}/>
            <SaveButton onClick={attachTag.bind(null)} isLoading={isLoading}/>
        </div>
    </Window>;
};
