import moment from 'moment';
import React from 'react';

import { Dict } from '../../../../types';
import { DUTY_STATE, ONE_SECOND } from '../../../constants';
import FormatDate, { prettySeconds } from '../../../ui/FormatDate';
import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import style from './index.css';
import { CALL_REQUESTS, REQUESTS } from './request';

interface ILastPerformersState {
    history: Dict<any>;
    requestIsLoading: boolean;
    tagsIsLoading: boolean;
    performers: Dict<any>;
}

interface ILastPerformersProps {
    user_id: string;
}

const HOURS_HISTORY = 35;

export class LastPerformers extends React.Component<ILastPerformersProps, ILastPerformersState> {
    state: ILastPerformersState = {
        history: {},
        requestIsLoading: true,
        tagsIsLoading: true,
        performers: {},
    };
    request = new Request2({ requestConfigs: CALL_REQUESTS });

    getData() {
        this.request.abort();
        this.props.user_id && this.setState({
            requestIsLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_REQUESTS, {
                queryParams: {
                    user_id: this.props.user_id,
                    since: Math.floor(+moment().subtract(HOURS_HISTORY, 'hours') / ONE_SECOND),
                },
            }).then(history => {
                const performers = new Set(history?.tags?.filter?.(el => el.call.exit)
                    ?.map(el => el?.tag_details?.performer) || []);
                const performers_id: any = [...performers];
                this.setState({
                    history,
                    requestIsLoading: false,
                    tagsIsLoading: true,
                }, () => {
                    Promise.all(performers_id.map(object_id => {
                        object_id && this.request.exec(REQUESTS.GET_USER_TAGS, {
                            queryParams: { object_id },
                        });
                    }))
                        .then(responseAll => {
                            this.setState({
                                tagsIsLoading: false,
                                performers: performers_id.reduce((_p: any, _c: any, index) => {
                                    if (!_p.hasOwnProperty(performers_id[index])) {
                                        _p[performers_id[index]] = responseAll[index];
                                    }

                                    return _p;
                                }, {}),
                            });
                        });
                });
            });
        });
    }

    componentDidMount() {
        this.getData();
    }

    render() {
        const tags = (this.state.history?.tags || []).filter(el => el?.call?.exit);

        return <>
            {
                tags.map((el: any, index) => {
                    return <LastPerformerItem el={el}
                                              index={index}
                                              key={index}
                                              users={this.state.history.users}
                                              performers={this.state.performers}/>;
                })
            }
            <div className={style.history_item}>
                <Link onClick={this.getData.bind(this)}>Обновить</Link> {this.state.requestIsLoading &&
            <Spin size={'s'}/>} {this.state.tagsIsLoading && <Spin size={'s'}/>}
            </div>
        </>;
    }
}

export const LastPerformerItem = React.memo((props: { el; index; users; performers }) => {
    const { el, index, users, performers } = props;
    const performer_id = el?.tag_details?.performer;
    const user = users?.find?.(user => user.id === performer_id)?.username;

    const categorization = el?.categorization?.items
        ?.map(el => el?.category?.meta?.label)?.join(', ');

    const isDuty = performers?.[performer_id]?.records?.find(el => el.tag === DUTY_STATE.COMMON);

    return <div key={index} className={style.history_item}>
        <div><span className={`${style.status} ${isDuty ? style.duty : ''}`}/> <FormatDate value={el?.call?.connect * ONE_SECOND}/>
            <span> (<strong>{prettySeconds(el?.call?.exit - el?.call?.enter || 0)}</strong>)</span>
            <span> <i><Link href={`#/clients/${performer_id}/info`}
                            target={'_blank'}>{user}</Link></i></span></div>
        <div className={style.history_item_categorization}>
            {categorization}
        </div>
    </div>;
});
