import { connect } from 'react-redux';
import { withRouter } from 'react-router';

import { getMyChats } from '../../../reducers/chatReducer/getters';
import { CallsNotify } from './component';

export interface ICallsNotifyProps {
    calls: any;
    users: any;
    tags: any;
}

export const mapStateToProps = (store): ICallsNotifyProps => {
    const messages = getMyChats(store);

    return {
        calls: messages?.calls || null,
        users: messages?.users || null,
        tags: messages?.tags || null,
    };
};

export default withRouter<any, any>(connect<ICallsNotifyProps>(mapStateToProps)(CallsNotify));
