import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_REQUESTS: 'GET_REQUESTS',
    GET_USER_TAGS: 'GET_USER_TAGS',
    ATTACH_USER_TAG: 'ATTACH_USER_TAG',
};

export const CALL_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_REQUESTS]: {
        api: 'support/requests',
        cgiObj: {
            since: null,
            user_id: null,
            tags: '@user_support_call_tag',
            rev: 'true',
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
        cgiObj: {
            tag: null,
            fields: null,
            priority: null,
            object_id: null,
        },
    },
};
