import React, { useEffect, useState } from 'react';

import { ONE_MONTH } from '../../../constants';
import { Window } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import { CSSettingsItems, CustomSettings } from '../../../utils/customSettings';
import { ytLogs } from '../../../utils/sendLogs';
import { EVENT_TYPES } from '../../../utils/sendLogs/eventTypes/eventTypes';
import style from './index.css';

const NDA_WARNING_LOG_LABEL = 'NDA_warning';

export class NDAWarning extends React.Component<any, any> {
    log: ytLogs | null = null;

    componentDidMount() {
        this.log = ytLogs.getInstance();
    }

    componentWillUnmount() {
        this.log?.send({
            data: { event_type: EVENT_TYPES.SHOW_TAB, tab_name: NDA_WARNING_LOG_LABEL },
        });
    }

    render() {
        return <Window onClose={this.props.onClose.bind(this)} title={'!!! NDA !!!'} className={style.modal}>
            <p>Люди нам доверяют и мы не должны их подводить, поэтому мы несём перед пользователями ответственность за
                конфиденциальность их данных. Утечка приватных данных наших пользователей напрямую отразится на
                репутации Компании.</p>
            <p>В ряде случаев это может стать основанием для применения контролирующими органами санкций к Компании или
                к её сотрудникам, а также основанием для судебных исков к Компании. Нарушение <Link href={'https://yandex.ru/legal/confidential/'} target={'_blank'}>политики
                    конфиденциальности</Link> может привести к административной или уголовной ответственности.
            </p>
            <p>Доступ к приватным данным пользователей должен осуществляться только для рабочей необходимости. Рабочая
                необходимость всегда связана с решением задачи, которая входит в должностные обязанности работника. Если
                задача не входит в компетенцию работника, то для таких задач работник не имеет права использовать
                приватные данные пользователей. Пожалуйста, сообщи Маше <Link href='mailto:mg@yandex-team.ru'
                                                                              target={'_blank'}>mg@yandex-team.ru</Link>,
                если ты видишь данные,
                которые тебе не нужны в работе.</p>
            <p>Подробнее <Link href={'https://wiki.yandex-team.ru/bst/assessors/nda/'} target={'_blank'}>
                https://wiki.yandex-team.ru/bst/assessors/nda/</Link></p>
        </Window>;
    }
}

export const NDALabel = React.memo(() => {
    const cs = new CustomSettings();
    const monthsAmount = 3;
    const [state, showNdaWarning] = useState(false);
    const [lastShowNDAWarning, setLastShowNDAWarning] = useState(cs.get(CSSettingsItems.lastShowNDAWarning));

    const setShowWarning = (value) => {
        showNdaWarning(value);

        if (!value) {
            const date = +new Date();
            cs.set(CSSettingsItems.lastShowNDAWarning, date);
            setLastShowNDAWarning(date);
        }
    };

    useEffect(() => {
        const nextShow = lastShowNDAWarning + monthsAmount * ONE_MONTH;
        showNdaWarning(!lastShowNDAWarning || nextShow <= +new Date());
    }, []);

    return <>
        {
            state && <NDAWarning onClose={setShowWarning.bind(null, false)}/>
        }
        <div className={style.nda_label} onClick={setShowWarning.bind(null, true)}>
            NDA
        </div>
    </>;
});
