import * as React from 'react';
import { RouteComponentProps } from 'react-router';

import FavouritesIcon from '../../../svg-components/favourites.component.svg';
import HomeIcon from '../../../svg-components/home.component.svg';
import { Link } from '../../ui/Link';
import ChatNotify from '../ChatNotify';
import { Favourites } from '../Favourites';
import { FavouritesModal } from '../Favourites/FavouritesModal';
import * as fav_style from '../Favourites/index.css';
import LeftMenu from '../LeftMenu/index';
import { Burger } from '../Menu';
import User from '../User';
import CallsNotify from './CallsNotify';
import GlobalSearch from './GlobalSearch';
import { IHeaderMapStateToProps } from './index';
import * as style from './index.css';
import { NDALabel } from './NDAWarning';

const HOME_PATH = '/';

interface IProps extends IHeaderMapStateToProps, RouteComponentProps {
}

interface IState {
    isActive: boolean;
    isFavEditOpen: boolean;
    isAddAction: boolean;
    error: Error | null;
}

export class Header extends React.Component<IProps, IState> {
    state: IState = {
        isActive: false,
        isFavEditOpen: false,
        isAddAction: true,
        error: null,
    };
    fv = new Favourites();

    toggleSideBar(value: boolean) {
        this.setState({
            isActive: value ?? false,
        });
    }

    click() {
        this.setState({
            isActive: !this.state.isActive,
        });
    }

    onFavouritesClick() {
        const { location } = this.props;
        if (this.fv.match(location.pathname + location.search)) {
            this.setState({ isFavEditOpen: true, isAddAction: false });
        } else {
            this.setState({ isFavEditOpen: true, isAddAction: true });
        }
    }

    closeFavEdit() {
        this.setState({ isFavEditOpen: false });
    }

    render() {
        const { isFavEditOpen, isActive, isAddAction } = this.state;
        const { location, blockRules, userId } = this.props;
        const fullPath = location.pathname + location.search;

        return <div className={style.component}>
            <div className={style.container}>
                <div className={style.logo_burger} onClick={this.click.bind(this)}>
                    <Burger active={isActive}/>
                    <div className={style.cup}>Драйв</div>
                </div>
                <NDALabel/>

                {
                    blockRules?.AvailableSearchPanel
                        ? <GlobalSearch/>
                        : <div/>
                }

                <div>
                    {
                        fullPath !== HOME_PATH
                            ? <>
                                <Link href={`#${HOME_PATH}`}>
                                    <HomeIcon className={fav_style.header_controls}/>
                                </Link>
                                <FavouritesIcon onClick={this.onFavouritesClick.bind(this)}
                                                className={`${fav_style.header_controls} ${this.fv.match(fullPath)
                                                    ? fav_style.fav_active
                                                    : null}`}/>
                            </>
                            : null
                    }
                </div>

                <CallsNotify/>
                {userId && <HeaderNotify/> || null}
                <User/>
                <LeftMenu active={isActive} toggleSideBar={this.toggleSideBar.bind(this)}/>

                {
                    isFavEditOpen
                        ? <FavouritesModal onClose={this.closeFavEdit.bind(this)}
                                           isAddAction={isAddAction}
                                           path={fullPath}/>
                        : null
                }
            </div>
        </div>;
    }
}

const HeaderNotify = React.memo(() => {
    return <div className={style.notify}>
        <ChatNotify/>
    </div>;
});
